/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.primitive.AbstractLongSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableLongSet extends AbstractLongSet implements ImmutableLongSet
{
    public ImmutableLongSet newWith(long element)
    {
        return LongHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableLongSet newWithout(long element)
    {
        return LongHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableLongSet newWithAll(LongIterable elements)
    {
        return LongHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableLongSet newWithoutAll(LongIterable elements)
    {
        return LongHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public LongSet freeze()
    {
        return this;
    }

    public ImmutableLongSet toImmutable()
    {
        return this;
    }
}
