/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.factory.map.primitive.MutableObjectShortMapFactory;
import com.gs.collections.api.map.primitive.MutableObjectShortMap;
import com.gs.collections.api.map.primitive.ObjectShortMap;

/**
 * MutableObjectShortMapFactoryImpl is a factory implementation which creates instances of type {@link MutableObjectShortMap}.
 * This file was automatically generated from template file mutableObjectPrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableObjectShortMapFactoryImpl implements MutableObjectShortMapFactory
{
    public <K> MutableObjectShortMap<K> empty()
    {
        return new ObjectShortHashMap(0);
    }

    public <K> MutableObjectShortMap<K> of()
    {
        return this.empty();
    }

    public <K> MutableObjectShortMap<K> with()
    {
        return this.empty();
    }

    public <K> MutableObjectShortMap<K> ofAll(ObjectShortMap<? extends K> map)
    {
        return this.withAll(map);
    }

    public <K> MutableObjectShortMap<K> withAll(ObjectShortMap<? extends K> map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new ObjectShortHashMap<K>(map);
    }
}
