/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.factory.map.primitive.MutableCharBooleanMapFactory;
import com.gs.collections.api.map.primitive.MutableCharBooleanMap;
import com.gs.collections.api.map.primitive.CharBooleanMap;

/**
 * MutableCharBooleanMapFactoryImpl is a factory implementation which creates instances of type {@link MutableCharBooleanMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableCharBooleanMapFactoryImpl implements MutableCharBooleanMapFactory
{
    public MutableCharBooleanMap empty()
    {
        return new CharBooleanHashMap(0);
    }

    public MutableCharBooleanMap of()
    {
        return this.empty();
    }

    public MutableCharBooleanMap with()
    {
        return this.empty();
    }

    public MutableCharBooleanMap ofAll(CharBooleanMap map)
    {
        return this.withAll(map);
    }

    public MutableCharBooleanMap withAll(CharBooleanMap map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new CharBooleanHashMap(map);
    }
}
