/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectLongPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectLongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableObjectLongMap;
import com.gs.collections.api.map.primitive.ObjectLongMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.ObjectLongPair;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.factory.primitive.ObjectLongMaps;
import com.gs.collections.impl.iterator.UnmodifiableLongIterator;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableObjectLongSingletonMap is an optimization for {@link ImmutableObjectLongMap} of size 1.
 * This file was automatically generated from template file immutableObjectPrimitiveSingletonMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectLongSingletonMap<K> extends AbstractImmutableObjectLongMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final K key1;
    private final long value1;

    ImmutableObjectLongSingletonMap(K key1, long value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public LongIterator longIterator()
    {
        return new UnmodifiableLongIterator(ObjectLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableLongCollection select(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? LongLists.immutable.with(this.value1) : LongLists.immutable.with();
    }

    public ImmutableLongCollection reject(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? LongLists.immutable.with() : LongLists.immutable.with(this.value1);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long sum()
    {
        return this.value1;
    }

    public long min()
    {
        return this.value1;
    }

    public long max()
    {
        return this.value1;
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.value1;
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public long[] toSortedArray()
    {
        return new long[]{this.value1};
    }

    public MutableLongList toSortedList()
    {
        return LongArrayList.newListWith(this.value1);
    }

    public long[] toArray()
    {
        return new long[]{this.value1};
    }

    public boolean contains(long value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(long... source)
    {
        for (long value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(LongIterable source)
    {
        for (LongIterator iterator = source.longIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableLongList toList()
    {
        return LongArrayList.newListWith(this.value1);
    }

    public MutableLongSet toSet()
    {
        return LongHashSet.newSetWith(this.value1);
    }

    public MutableLongBag toBag()
    {
        return LongHashBag.newBagWith(this.value1);
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableObjectLongMap<K> newWithKeyValue(K key, long value)
    {
        return ObjectLongMaps.immutable.withAll(ObjectLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectLongMap<K> newWithoutKey(K key)
    {
        return nullSafeEquals(this.key1, key) ? (ImmutableObjectLongMap<K>) ImmutableObjectLongEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other)
    {
        if (value == null)
        {
            if (other == null)
            {
                return true;
            }
        }
        else if (other == value || value.equals(other))
        {
            return true;
        }
        return false;
    }

    public ImmutableObjectLongMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectLongHashMap<K> map = new ObjectLongHashMap<K>(this);
        for (K key : keys)
        {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public long get(Object key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public long getOrThrow(Object key)
    {
        if (nullSafeEquals(this.key1, key))
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public long getIfAbsent(Object key, long ifAbsent)
    {
        return nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key)
    {
        return nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(long value)
    {
        return this.value1 == value;
    }

    public void forEachValue(LongProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectLongProcedure<? super K> objectLongProcedure)
    {
        objectLongProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectLongMap<K> select(ObjectLongPredicate<? super K> objectLongPredicate)
    {
        return objectLongPredicate.accept(this.key1, this.value1) ? ObjectLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : (ImmutableObjectLongMap<K>) ImmutableObjectLongEmptyMap.INSTANCE;
    }

    public ImmutableObjectLongMap<K> reject(ObjectLongPredicate<? super K> objectLongPredicate)
    {
        return objectLongPredicate.accept(this.key1, this.value1) ? (ImmutableObjectLongMap<K>) ImmutableObjectLongEmptyMap.INSTANCE
                : ObjectLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectLongMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public Set<K> keySet()
    {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(LongArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView()
    {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectLongPair<K>> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ObjectLongMap))
        {
            return false;
        }
        ObjectLongMap<K> map = (ObjectLongMap<K>) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ (int) (this.value1 ^ this.value1 >>> 32);
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace()
    {
        return new ImmutableObjectLongMapSerializationProxy<K>(this);
    }
}
