/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableIntIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntIntMap;
import com.gs.collections.api.map.primitive.IntIntMap;

/**
 * ImmutableIntIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntIntMapFactoryImpl implements ImmutableIntIntMapFactory
{
    public ImmutableIntIntMap empty()
    {
        return ImmutableIntIntEmptyMap.INSTANCE;
    }

    public ImmutableIntIntMap of()
    {
        return this.empty();
    }

    public ImmutableIntIntMap with()
    {
        return this.empty();
    }

    public ImmutableIntIntMap of(int key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableIntIntMap with(int key, int value)
    {
        return new ImmutableIntIntSingletonMap(key, value);
    }

    public ImmutableIntIntMap ofAll(IntIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableIntIntMap withAll(IntIntMap map)
    {
        if (map instanceof ImmutableIntIntMap)
        {
            return (ImmutableIntIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntIntSingletonMap(key, map.get(key));
        }
        return new ImmutableIntIntHashMap(map);
    }
}
