/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.IntDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.IntDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableIntDoubleMap;
import com.gs.collections.api.map.primitive.MutableIntDoubleMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.IntDoublePair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedIntDoubleProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.map.mutable.primitive.IntDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

/**
 * ImmutableIntDoubleHashMap is the non-modifiable equivalent of {@link IntDoubleHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableIntDoubleHashMap implements ImmutableIntDoubleMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableIntDoubleMap delegate;

    ImmutableIntDoubleHashMap(IntDoubleMap delegate)
    {
        this.delegate = new IntDoubleHashMap(delegate);
    }

    public double get(int key)
    {
        return this.delegate.get(key);
    }

    public double getIfAbsent(int key, double ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(int key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(int key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(double value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(IntDoubleProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<IntDoublePair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableIntDoubleMap select(IntDoublePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntDoubleMap reject(IntDoublePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableIntDoubleMap toImmutable()
    {
        return this;
    }

    public DoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(this.delegate.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(DoubleProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public double max()
    {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double min()
    {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public double[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public double[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(double value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableIntDoubleMap newWithKeyValue(int key, double value)
    {
        MutableIntDoubleMap map = new IntDoubleHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableIntDoubleMap newWithoutKey(int key)
    {
        MutableIntDoubleMap map = new IntDoubleHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableIntDoubleMap newWithoutAllKeys(IntIterable keys)
    {
        MutableIntDoubleMap map = new IntDoubleHashMap(this.size());
        map.putAll(this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    public MutableDoubleCollection values()
    {
        return UnmodifiableDoubleCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableIntDoubleMapSerializationProxy(this);
    }

    protected static class ImmutableIntDoubleMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private IntDoubleMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableIntDoubleMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableIntDoubleMapSerializationProxy(IntDoubleMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedIntDoubleProcedure()
                {
                    @Override
                    public void safeValue(int key, double value) throws IOException
                    {
                        out.writeInt(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableIntDoubleMap deserializedMap = new IntDoubleHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readInt(), in.readDouble());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
