/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.DoubleFloatMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleFloatMap;
import com.gs.collections.api.map.primitive.MutableDoubleFloatMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.DoubleFloatPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleFloatProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.map.mutable.primitive.DoubleFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

/**
 * ImmutableDoubleFloatHashMap is the non-modifiable equivalent of {@link DoubleFloatHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableDoubleFloatHashMap implements ImmutableDoubleFloatMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableDoubleFloatMap delegate;

    ImmutableDoubleFloatHashMap(DoubleFloatMap delegate)
    {
        this.delegate = new DoubleFloatHashMap(delegate);
    }

    public float get(double key)
    {
        return this.delegate.get(key);
    }

    public float getIfAbsent(double key, float ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(double key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(float value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleFloatProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<DoubleFloatPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableDoubleFloatMap select(DoubleFloatPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleFloatMap reject(DoubleFloatPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableDoubleFloatMap toImmutable()
    {
        return this;
    }

    public FloatIterator floatIterator()
    {
        return new UnmodifiableFloatIterator(this.delegate.floatIterator());
    }

    public void forEach(FloatProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(FloatPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public float max()
    {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public float min()
    {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public float[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public float[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(float value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(float... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(FloatIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableFloatList toList()
    {
        return this.delegate.toList();
    }

    public MutableFloatSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableFloatBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyFloatIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleFloatMap newWithKeyValue(double key, float value)
    {
        MutableDoubleFloatMap map = new DoubleFloatHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleFloatMap newWithoutKey(double key)
    {
        MutableDoubleFloatMap map = new DoubleFloatHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleFloatMap newWithoutAllKeys(DoubleIterable keys)
    {
        MutableDoubleFloatMap map = new DoubleFloatHashMap(this.size());
        map.putAll(this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableDoubleFloatMapSerializationProxy(this);
    }

    protected static class ImmutableDoubleFloatMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private DoubleFloatMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableDoubleFloatMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableDoubleFloatMapSerializationProxy(DoubleFloatMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedDoubleFloatProcedure()
                {
                    @Override
                    public void safeValue(double key, float value) throws IOException
                    {
                        out.writeDouble(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableDoubleFloatMap deserializedMap = new DoubleFloatHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readDouble(), in.readFloat());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
