/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.ImmutableLongList;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.iterator.UnmodifiableLongIterator;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseLongIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableLongSingletonList is an optimization for {@link ImmutableLongList} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonList.stg.
 */
@Immutable
final class ImmutableLongSingletonList implements ImmutableLongList, Serializable
{
    private static final long serialVersionUID = 1L;
    private final long element1;

    ImmutableLongSingletonList(long element)
    {
        this.element1 = element;
    }

    public long get(int index)
    {
        if (index == 0)
        {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public long getFirst()
    {
        return this.element1;
    }

    public long getLast()
    {
        return this.element1;
    }

    public int indexOf(long value)
    {
        return this.element1 == value ? 0 : -1;
    }

    public int lastIndexOf(long value)
    {
        return this.element1 == value ? 0 : -1;
    }

    public LongIterator longIterator()
    {
        return new UnmodifiableLongIterator(LongArrayList.newListWith(this.element1).longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(LongIntProcedure procedure)
    {
        procedure.value(this.element1, 0);
    }

    public int count(LongPredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public ImmutableLongList select(LongPredicate predicate)
    {
        return predicate.accept(this.element1) ? LongArrayList.newListWith(this.element1).toImmutable()
                : new LongArrayList().toImmutable();
    }

    public ImmutableLongList reject(LongPredicate predicate)
    {
        return predicate.accept(this.element1) ? new LongArrayList().toImmutable()
                : LongArrayList.newListWith(this.element1).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(LongToObjectFunction<? extends V> function)
    {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public long sum()
    {
        return this.element1;
    }

    public long max()
    {
        return this.element1;
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.element1;
    }

    public long min()
    {
        return this.element1;
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public long[] toSortedArray()
    {
        return new long[]{this.element1};
    }

    public MutableLongList toSortedList()
    {
        return LongArrayList.newListWith(this.element1);
    }

    public int binarySearch(long value)
    {
        if (this.element1 == value)
        {
            return 0;
        }
        if (this.element1 < value)
        {
            return -2;
        }
        return -1;
    }

    public long dotProduct(LongList list)
    {
        if (list.size() != 1)
        {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return this.element1 * list.getFirst();
    }

    public long[] toArray()
    {
        return new long[]{this.element1};
    }

    public boolean contains(long value)
    {
        return this.element1 == value;
    }

    public boolean containsAll(long... source)
    {
        for (long value : source)
        {
            if (this.element1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(LongIterable source)
    {
        for (LongIterator iterator = source.longIterator(); iterator.hasNext(); )
        {
            if (this.element1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public LazyLongIterable asReversed()
    {
        return ReverseLongIterable.adapt(this);
    }

    public MutableLongList toList()
    {
        return LongArrayList.newListWith(this.element1);
    }

    public MutableLongSet toSet()
    {
        return LongHashSet.newSetWith(this.element1);
    }

    public MutableLongBag toBag()
    {
        return LongHashBag.newBagWith(this.element1);
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableLongList toImmutable()
    {
        return this;
    }

    public ImmutableLongSingletonList toReversed()
    {
        return this;
    }

    public ImmutableLongList newWith(long element)
    {
        return LongLists.immutable.with(this.element1, element);
    }

    public ImmutableLongList newWithout(long element)
    {
        return this.element1 == element ? LongLists.immutable.with() : this;
    }

    public ImmutableLongList newWithAll(LongIterable elements)
    {
        LongArrayList arrayList = LongArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableLongList newWithoutAll(LongIterable elements)
    {
        return elements.contains(this.element1) ? LongLists.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1, 0);
    }

    @Override
    public boolean equals(Object otherList)
    {
        if (otherList == this)
        {
            return true;
        }
        if (!(otherList instanceof LongList))
        {
            return false;
        }
        LongList list = (LongList) otherList;
        if (list.size() != 1)
        {
            return false;
        }
        return this.element1 == list.get(0);
    }

    @Override
    public int hashCode()
    {
        return 31 + (int) (this.element1 ^ this.element1 >>> 32);
    }

    @Override
    public String toString()
    {
        return "[" + this.element1 + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    /**
     * @since 6.0.
     */
    public ImmutableLongList distinct()
    {
        return this;
    }

    public ImmutableLongList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
