/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToDoubleFunction;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.iterator.DoubleIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectShortToDoubleIterable
        extends AbstractLazyDoubleIterable
{
    private final ShortIterable iterable;
    private final ShortToDoubleFunction function;

    public CollectShortToDoubleIterable(ShortIterable iterable, ShortToDoubleFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final DoubleProcedure procedure)
    {
        this.iterable.forEach(new ShortProcedure()
        {
            public void value(short each)
            {
                procedure.value(CollectShortToDoubleIterable.this.function.valueOf(each));
            }
        });
    }

    public DoubleIterator doubleIterator()
    {
        return new DoubleIterator()
        {
            private final ShortIterator iterator = CollectShortToDoubleIterable.this.iterable.shortIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public double next()
            {
                return CollectShortToDoubleIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
