/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToDoubleFunction;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.iterator.DoubleIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectLongToDoubleIterable
        extends AbstractLazyDoubleIterable
{
    private final LongIterable iterable;
    private final LongToDoubleFunction function;

    public CollectLongToDoubleIterable(LongIterable iterable, LongToDoubleFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final DoubleProcedure procedure)
    {
        this.iterable.forEach(new LongProcedure()
        {
            public void value(long each)
            {
                procedure.value(CollectLongToDoubleIterable.this.function.valueOf(each));
            }
        });
    }

    public DoubleIterator doubleIterator()
    {
        return new DoubleIterator()
        {
            private final LongIterator iterator = CollectLongToDoubleIterable.this.iterable.longIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public double next()
            {
                return CollectLongToDoubleIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
