/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.factory.primitive;

import com.gs.collections.api.factory.list.primitive.ImmutableCharListFactory;
import com.gs.collections.api.factory.list.primitive.MutableCharListFactory;
import com.gs.collections.impl.list.immutable.primitive.ImmutableCharListFactoryImpl;
import com.gs.collections.impl.list.mutable.primitive.MutableCharListFactoryImpl;

/**
 * CharLists is a static utility for creating {@link ImmutableCharListFactory}.
 * This file was automatically generated from template file primitiveLists.stg.
 *
 * @since 3.2.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class CharLists
{
    public static final ImmutableCharListFactory immutable = new ImmutableCharListFactoryImpl();
    public static final MutableCharListFactory mutable = new MutableCharListFactoryImpl();

    private CharLists()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
