/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.collection.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.MutableFloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file abstractUnmodifiablePrimitiveCollection.stg.
 *
 * @since 3.1.
 */
@ThreadSafe
public abstract class AbstractUnmodifiableFloatCollection
        implements MutableFloatCollection, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableFloatCollection collection;

    protected AbstractUnmodifiableFloatCollection(MutableFloatCollection collection)
    {
        this.collection = collection;
    }

    protected MutableFloatCollection getFloatCollection()
    {
        return this.collection;
    }

    public int size()
    {
        return this.collection.size();
    }

    public boolean isEmpty()
    {
        return this.collection.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.collection.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(float value)
    {
        return this.collection.contains(value);
    }

    public boolean containsAll(float... source)
    {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(FloatIterable source)
    {
        return this.collection.containsAll(source);
    }

    public boolean add(float newItem)
    {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(float... source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(FloatIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(float value)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(FloatIterable source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(float... source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(FloatIterable source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(float... source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableFloatIterator floatIterator()
    {
        return new UnmodifiableFloatIterator(this.collection.floatIterator());
    }

    public void forEach(FloatProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
        this.collection.forEach(procedure);
    }

    public int count(FloatPredicate predicate)
    {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableFloatCollection select(FloatPredicate predicate)
    {
        return this.collection.select(predicate);
    }

    public MutableFloatCollection reject(FloatPredicate predicate)
    {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.collection.collect(function);
    }

    public MutableFloatCollection with(float element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableFloatCollection without(float element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableFloatCollection withAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableFloatCollection withoutAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableFloatCollection asUnmodifiable()
    {
        return this;
    }

    public MutableFloatCollection asSynchronized()
    {
        return new SynchronizedFloatCollection(this);
    }

    public ImmutableFloatCollection toImmutable()
    {
        return this.collection.toImmutable();
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public double sum()
    {
        return this.collection.sum();
    }

    public float max()
    {
        return this.collection.max();
    }

    public float min()
    {
        return this.collection.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.collection.minIfEmpty(defaultValue);
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.collection.average();
    }

    public double median()
    {
        return this.collection.median();
    }

    public MutableFloatList toSortedList()
    {
        return this.collection.toSortedList();
    }

    public float[] toSortedArray()
    {
        return this.collection.toSortedArray();
    }

    public float[] toArray()
    {
        return this.collection.toArray();
    }

    @Override
    public String toString()
    {
        return this.collection.toString();
    }

    public String makeString()
    {
        return this.collection.makeString();
    }

    public String makeString(String separator)
    {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableFloatList toList()
    {
        return this.collection.toList();
    }

    public MutableFloatSet toSet()
    {
        return this.collection.toSet();
    }

    public MutableFloatBag toBag()
    {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.collection.injectInto(injectedValue, function);
    }
}
