/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.bag.primitive.MutableIntBagFactory;
import com.gs.collections.api.bag.primitive.MutableIntBag;

/**
 * MutableIntBagFactoryImpl is a factory implementation which creates instances of type {@link MutableIntBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableIntBagFactoryImpl implements MutableIntBagFactory
{
    public MutableIntBag empty()
    {
        return new IntHashBag();
    }

    public MutableIntBag of()
    {
        return this.empty();
    }

    public MutableIntBag with()
    {
        return this.empty();
    }

    public MutableIntBag of(int... items)
    {
        return this.with(items);
    }

    public MutableIntBag with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return IntHashBag.newBagWith(items);
    }

    public MutableIntBag ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public MutableIntBag withAll(IntIterable items)
    {
        return IntHashBag.newBag(items);
    }
}
