/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.bag.primitive.ImmutableIntBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableIntBagFactory;

/**
 * ImmutableIntBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntBagFactoryImpl implements ImmutableIntBagFactory
{
    public ImmutableIntBag empty()
    {
        return ImmutableIntEmptyBag.INSTANCE;
    }

    public ImmutableIntBag of()
    {
        return this.empty();
    }

    public ImmutableIntBag with()
    {
        return this.empty();
    }

    public ImmutableIntBag of(int one)
    {
        return this.with(one);
    }

    public ImmutableIntBag with(int one)
    {
        return new ImmutableIntSingletonBag(one);
    }

    public ImmutableIntBag of(int... items)
    {
        return this.with(items);
    }

    public ImmutableIntBag with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableIntHashBag.newBagWith(items);
    }

    public ImmutableIntBag ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableIntBag withAll(IntIterable items)
    {
        if (items instanceof ImmutableIntBag)
        {
            return (ImmutableIntBag) items;
        }
        return this.with(items.toArray());
    }
}
