/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableFloatBagFactory;

/**
 * ImmutableFloatBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatBagFactoryImpl implements ImmutableFloatBagFactory
{
    public ImmutableFloatBag empty()
    {
        return ImmutableFloatEmptyBag.INSTANCE;
    }

    public ImmutableFloatBag of()
    {
        return this.empty();
    }

    public ImmutableFloatBag with()
    {
        return this.empty();
    }

    public ImmutableFloatBag of(float one)
    {
        return this.with(one);
    }

    public ImmutableFloatBag with(float one)
    {
        return new ImmutableFloatSingletonBag(one);
    }

    public ImmutableFloatBag of(float... items)
    {
        return this.with(items);
    }

    public ImmutableFloatBag with(float... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableFloatHashBag.newBagWith(items);
    }

    public ImmutableFloatBag ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableFloatBag withAll(FloatIterable items)
    {
        if (items instanceof ImmutableFloatBag)
        {
            return (ImmutableFloatBag) items;
        }
        return this.with(items.toArray());
    }
}
