/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import java.io.File;
import java.io.IOException;
import org.scijava.nativelib.NativeLibraryUtil;

public class NativeLoader {
    public static boolean isAppleSilicon() {
        return NativeLibraryUtil.getArchitecture() == NativeLibraryUtil.Architecture.OSX_ARM64;
    }

    public static void loadAppleSilicon() {
        if (NativeLoader.isAppleSilicon()) {
            System.setProperty("jna.nosys", "true");
        }
    }

    static {
        if (NativeLoader.isAppleSilicon()) {
            try {
                String path = NativeLibraryUtil.getPlatformLibraryPath((String)"natives/");
                File extracted = org.scijava.nativelib.NativeLoader.getJniExtractor().extractJni(path, "jnidispatch");
                if (extracted == null) {
                    throw new IllegalStateException("extract osx arm64 libjnidispatch.jnilib failed.");
                }
                extracted.deleteOnExit();
                System.setProperty("jna.boot.library.path", extracted.getParentFile().getAbsolutePath());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

