/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.http.AbstractHttpClient;
import com.wechat.pay.java.core.http.AbstractHttpClientBuilder;
import com.wechat.pay.java.core.http.okhttp.OkHttpClientAdapter;
import com.wechat.pay.java.core.http.okhttp.OkHttpMultiDomainInterceptor;
import java.net.Proxy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultHttpClientBuilder
implements AbstractHttpClientBuilder<DefaultHttpClientBuilder> {
    private Credential credential;
    private Validator validator;
    private static final OkHttpClient defaultOkHttpClient = new OkHttpClient();
    private OkHttpClient customizeOkHttpClient;
    private int readTimeoutMs = -1;
    private int writeTimeoutMs = -1;
    private int connectTimeoutMs = -1;
    private Proxy proxy;
    private boolean retryMultiDomain = false;
    private Boolean retryOnConnectionFailure = null;
    private static final OkHttpMultiDomainInterceptor multiDomainInterceptor = new OkHttpMultiDomainInterceptor();

    @Override
    public DefaultHttpClientBuilder newInstance() {
        DefaultHttpClientBuilder result = new DefaultHttpClientBuilder();
        result.credential = this.credential;
        result.validator = this.validator;
        result.customizeOkHttpClient = this.customizeOkHttpClient;
        result.readTimeoutMs = this.readTimeoutMs;
        result.writeTimeoutMs = this.writeTimeoutMs;
        result.connectTimeoutMs = this.connectTimeoutMs;
        result.proxy = this.proxy;
        return result;
    }

    public DefaultHttpClientBuilder readTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
        return this;
    }

    public DefaultHttpClientBuilder writeTimeoutMs(int writeTimeoutMs) {
        this.writeTimeoutMs = writeTimeoutMs;
        return this;
    }

    public DefaultHttpClientBuilder connectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
        return this;
    }

    @Override
    public DefaultHttpClientBuilder credential(Credential credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public DefaultHttpClientBuilder validator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public DefaultHttpClientBuilder okHttpClient(OkHttpClient okHttpClient) {
        this.customizeOkHttpClient = okHttpClient;
        return this;
    }

    public DefaultHttpClientBuilder config(Config config) {
        Objects.requireNonNull(config);
        this.credential = config.createCredential();
        this.validator = config.createValidator();
        return this;
    }

    public DefaultHttpClientBuilder proxy(Proxy proxy) {
        Objects.requireNonNull(proxy);
        this.proxy = proxy;
        return this;
    }

    public DefaultHttpClientBuilder enableRetryMultiDomain() {
        this.retryMultiDomain = true;
        return this;
    }

    public DefaultHttpClientBuilder disableRetryOnConnectionFailure() {
        this.retryOnConnectionFailure = false;
        return this;
    }

    @Override
    public AbstractHttpClient build() {
        OkHttpClient.Builder okHttpClientBuilder;
        Objects.requireNonNull(this.credential);
        Objects.requireNonNull(this.validator);
        if (this.customizeOkHttpClient != null) {
            okHttpClientBuilder = this.customizeOkHttpClient.newBuilder();
        } else {
            okHttpClientBuilder = defaultOkHttpClient.newBuilder();
            okHttpClientBuilder.connectionPool(new ConnectionPool(5, 7L, TimeUnit.SECONDS));
        }
        if (this.connectTimeoutMs >= 0) {
            okHttpClientBuilder.connectTimeout((long)this.connectTimeoutMs, TimeUnit.MILLISECONDS);
        }
        if (this.readTimeoutMs >= 0) {
            okHttpClientBuilder.readTimeout((long)this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        if (this.writeTimeoutMs >= 0) {
            okHttpClientBuilder.writeTimeout((long)this.writeTimeoutMs, TimeUnit.MILLISECONDS);
        }
        if (this.proxy != null) {
            okHttpClientBuilder.proxy(this.proxy);
        }
        if (this.retryMultiDomain) {
            okHttpClientBuilder.addInterceptor((Interceptor)multiDomainInterceptor);
        }
        if (this.retryOnConnectionFailure != null && !this.retryOnConnectionFailure.booleanValue()) {
            okHttpClientBuilder.retryOnConnectionFailure(false);
        }
        return new OkHttpClientAdapter(this.credential, this.validator, okHttpClientBuilder.build());
    }
}

