/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.cipher;

import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.exception.DecryptionException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractAeadCipher
implements AeadCipher {
    private final String algorithm;
    private final String transformation;
    private final int tagLengthBit;
    private final byte[] key;

    protected AbstractAeadCipher(String algorithm, String transformation, int tagLengthBit, byte[] key) {
        this.algorithm = algorithm;
        this.transformation = transformation;
        this.tagLengthBit = tagLengthBit;
        this.key = key;
    }

    @Override
    public String encrypt(byte[] associatedData, byte[] nonce, byte[] plaintext) {
        try {
            Cipher cipher = Cipher.getInstance(this.transformation);
            cipher.init(1, (Key)new SecretKeySpec(this.key, this.algorithm), new GCMParameterSpec(this.tagLengthBit, nonce));
            if (associatedData != null) {
                cipher.updateAAD(associatedData);
            }
            return Base64.getEncoder().encodeToString(cipher.doFinal(plaintext));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String decrypt(byte[] associatedData, byte[] nonce, byte[] ciphertext) {
        try {
            Cipher cipher = Cipher.getInstance(this.transformation);
            cipher.init(2, (Key)new SecretKeySpec(this.key, this.algorithm), new GCMParameterSpec(this.tagLengthBit, nonce));
            if (associatedData != null) {
                cipher.updateAAD(associatedData);
            }
            return new String(cipher.doFinal(ciphertext), StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new DecryptionException("Decryption failed", e);
        }
    }
}

