/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.certificate;

import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.auth.WechatPay2Credential;
import com.wechat.pay.java.core.certificate.AbstractAutoCertificateProvider;
import com.wechat.pay.java.core.certificate.CertificateHandler;
import com.wechat.pay.java.core.certificate.RSACertificateHandler;
import com.wechat.pay.java.core.cipher.AeadAesCipher;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.cipher.RSASigner;
import com.wechat.pay.java.core.http.AbstractHttpClientBuilder;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class RSAAutoCertificateProvider
extends AbstractAutoCertificateProvider {
    private static final Map<String, Map<String, X509Certificate>> wechatPayCertificateMap = new ConcurrentHashMap<String, Map<String, X509Certificate>>();
    private static final CertificateHandler rsaCertificateHandler = new RSACertificateHandler();
    private static final String REQUEST_URL = "https://api.mch.weixin.qq.com/v3/certificates?algorithm_type=RSA";

    private RSAAutoCertificateProvider(String merchantId, AeadCipher aeadCipher, HttpClient httpClient) {
        super(REQUEST_URL, rsaCertificateHandler, aeadCipher, httpClient, merchantId, wechatPayCertificateMap);
    }

    public static class Builder {
        private String merchantId;
        private byte[] apiV3Key;
        private Credential credential;
        private PrivateKey privateKey;
        private String merchantSerialNumber;
        private HttpClient httpClient;
        private AbstractHttpClientBuilder<?> httpClientBuilder;
        private final Validator emptyValidator = new Validator(){

            @Override
            public boolean validate(HttpHeaders responseHeaders, String body) {
                return true;
            }
        };

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder apiV3Key(byte[] apiV3Key) {
            this.apiV3Key = apiV3Key;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder merchantSerialNumber(String merchantSerialNumber) {
            this.merchantSerialNumber = merchantSerialNumber;
            return this;
        }

        public Builder httpClientBuilder(AbstractHttpClientBuilder<?> builder) {
            this.httpClientBuilder = builder.newInstance();
            return this;
        }

        public RSAAutoCertificateProvider build() {
            if (this.httpClient == null) {
                if (this.httpClientBuilder == null) {
                    this.httpClientBuilder = new DefaultHttpClientBuilder();
                }
                if (this.credential == null && this.privateKey != null) {
                    this.credential = new WechatPay2Credential(Objects.requireNonNull(this.merchantId), new RSASigner(Objects.requireNonNull(this.merchantSerialNumber), this.privateKey));
                }
                this.httpClient = this.httpClientBuilder.credential(this.credential).validator(this.emptyValidator).build();
            }
            return new RSAAutoCertificateProvider(this.merchantId, new AeadAesCipher(Objects.requireNonNull(this.apiV3Key)), this.httpClient);
        }
    }
}

