/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.certificate;

import com.wechat.pay.java.core.certificate.CertificateHandler;
import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.certificate.SafeSingleScheduleExecutor;
import com.wechat.pay.java.core.certificate.model.Data;
import com.wechat.pay.java.core.certificate.model.DownloadCertificateResponse;
import com.wechat.pay.java.core.certificate.model.EncryptCertificate;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.util.PemUtil;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutoCertificateProvider
implements CertificateProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractAutoCertificateProvider.class);
    protected static final int UPDATE_INTERVAL_MINUTE = 60;
    protected final SafeSingleScheduleExecutor executor = SafeSingleScheduleExecutor.getInstance();
    protected String merchantId;
    protected CertificateHandler certificateHandler;
    protected AeadCipher aeadCipher;
    protected HttpClient httpClient;
    private final HttpRequest httpRequest;
    private int updateCount;
    private int succeedCount;
    private final Map<String, Map<String, X509Certificate>> certificateMap;

    protected AbstractAutoCertificateProvider(String requestUrl, CertificateHandler certificateHandler, AeadCipher aeadCipher, HttpClient httpClient, String merchantId, Map<String, Map<String, X509Certificate>> wechatPayCertificateMap) {
        this(requestUrl, certificateHandler, aeadCipher, httpClient, merchantId, wechatPayCertificateMap, 3600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAutoCertificateProvider(String requestUrl, CertificateHandler certificateHandler, AeadCipher aeadCipher, HttpClient httpClient, String merchantId, Map<String, Map<String, X509Certificate>> wechatPayCertificateMap, int updateInterval) {
        this.merchantId = merchantId;
        Class<AbstractAutoCertificateProvider> clazz = AbstractAutoCertificateProvider.class;
        synchronized (AbstractAutoCertificateProvider.class) {
            if (wechatPayCertificateMap.containsKey(merchantId)) {
                throw new IllegalStateException("The corresponding provider for the merchant already exists.");
            }
            wechatPayCertificateMap.put(merchantId, new HashMap());
            // ** MonitorExit[var8_8] (shouldn't be in output)
            this.certificateHandler = certificateHandler;
            this.aeadCipher = aeadCipher;
            this.httpClient = httpClient;
            this.certificateMap = wechatPayCertificateMap;
            this.httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestUrl).addHeader("Accept", " */*").addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue()).build();
            this.downloadAndUpdate(wechatPayCertificateMap);
            Runnable runnable = () -> {
                log.info("Begin update Certificates.merchantId:{},total updates:{}", (Object)merchantId, (Object)this.updateCount);
                try {
                    ++this.updateCount;
                    this.downloadAndUpdate(wechatPayCertificateMap);
                    ++this.succeedCount;
                }
                catch (Exception e) {
                    log.error("Download and update WechatPay certificates failed.", (Throwable)e);
                }
                log.info("Finish update Certificates.merchantId:{},total updates:{}, succeed updates:{}", new Object[]{merchantId, this.updateCount, this.succeedCount});
            };
            this.executor.scheduleAtFixedRate(runnable, updateInterval, updateInterval, TimeUnit.SECONDS);
            return;
        }
    }

    protected void downloadAndUpdate(Map<String, Map<String, X509Certificate>> wechatPayCertificateMap) {
        HttpResponse<DownloadCertificateResponse> httpResponse = this.downloadCertificate(this.httpClient);
        Map<String, X509Certificate> downloaded = this.decryptCertificate(httpResponse);
        this.validateCertificate(downloaded);
        wechatPayCertificateMap.put(this.merchantId, downloaded);
    }

    protected HttpResponse<DownloadCertificateResponse> downloadCertificate(HttpClient httpClient) {
        HttpResponse<DownloadCertificateResponse> httpResponse = httpClient.execute(this.httpRequest, DownloadCertificateResponse.class);
        return httpResponse;
    }

    protected void validateCertificate(Map<String, X509Certificate> certificates) {
        certificates.forEach((serialNo, cert) -> this.certificateHandler.validateCertPath((X509Certificate)cert));
    }

    protected Map<String, X509Certificate> decryptCertificate(HttpResponse<DownloadCertificateResponse> httpResponse) {
        List<Data> dataList = httpResponse.getServiceResponse().getData();
        HashMap<String, X509Certificate> downloadCertMap = new HashMap<String, X509Certificate>();
        for (Data data : dataList) {
            EncryptCertificate encryptCertificate = data.getEncryptCertificate();
            String decryptCertificate = this.aeadCipher.decrypt(encryptCertificate.getAssociatedData().getBytes(StandardCharsets.UTF_8), encryptCertificate.getNonce().getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(encryptCertificate.getCiphertext()));
            X509Certificate certificate = this.certificateHandler.generateCertificate(decryptCertificate);
            downloadCertMap.put(PemUtil.getSerialNumber(certificate), certificate);
        }
        return downloadCertMap;
    }

    public X509Certificate getAvailableCertificate(Map<String, X509Certificate> certificateMap) {
        X509Certificate longest = null;
        for (X509Certificate item : certificateMap.values()) {
            if (longest != null && !item.getNotAfter().after(longest.getNotAfter())) continue;
            longest = item;
        }
        return longest;
    }

    @Override
    public X509Certificate getCertificate(String serialNumber) {
        return this.certificateMap.get(this.merchantId).get(serialNumber);
    }

    @Override
    public X509Certificate getAvailableCertificate() {
        return this.getAvailableCertificate(this.certificateMap.get(this.merchantId));
    }
}

