/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.shiro;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.util.CollectionUtils;

public class SessionWrapper
implements Serializable {
    private Serializable id;
    private Date startTimestamp;
    private Date stopTimestamp;
    private Date lastAccessTime;
    private long timeout;
    private boolean expired;
    private String host;
    private Map<Object, Object> attributes;
    private Date createTime;
    private static int bitIndexCounter = 0;
    private static final int ID_BIT_MASK = 1 << bitIndexCounter++;
    private static final int START_TIMESTAMP_BIT_MASK = 1 << bitIndexCounter++;
    private static final int STOP_TIMESTAMP_BIT_MASK = 1 << bitIndexCounter++;
    private static final int LAST_ACCESS_TIME_BIT_MASK = 1 << bitIndexCounter++;
    private static final int TIMEOUT_BIT_MASK = 1 << bitIndexCounter++;
    private static final int EXPIRED_BIT_MASK = 1 << bitIndexCounter++;
    private static final int HOST_BIT_MASK = 1 << bitIndexCounter++;
    private static final int ATTRIBUTES_BIT_MASK = 1 << bitIndexCounter++;

    public Session getSession() {
        SimpleSession simpleSession = new SimpleSession();
        simpleSession.setId(this.getId());
        simpleSession.setStartTimestamp(this.getStartTimestamp());
        simpleSession.setStopTimestamp(this.getStopTimestamp());
        simpleSession.setLastAccessTime(this.getLastAccessTime());
        simpleSession.setTimeout(this.getTimeout());
        simpleSession.setExpired(this.isExpired());
        simpleSession.setHost(this.getHost());
        simpleSession.setAttributes(this.getAttributes());
        return simpleSession;
    }

    public void setSession(Session session) {
        this.setId(session.getId());
        this.setStartTimestamp(session.getStartTimestamp());
        this.setLastAccessTime(session.getLastAccessTime());
        this.setTimeout(session.getTimeout());
        this.setHost(session.getHost());
        if (session instanceof SimpleSession) {
            this.setStopTimestamp(((SimpleSession)session).getStopTimestamp());
            this.setExpired(((SimpleSession)session).isExpired());
            this.setAttributes(((SimpleSession)session).getAttributes());
        }
    }

    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStopTimestamp() {
        return this.stopTimestamp;
    }

    public void setStopTimestamp(Date stopTimestamp) {
        this.stopTimestamp = stopTimestamp;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<Object, Object> attributes) {
        this.attributes = attributes;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        short alteredFieldsBitMask = this.getAlteredFieldsBitMask();
        out.writeShort(alteredFieldsBitMask);
        if (this.id != null) {
            out.writeObject(this.id);
        }
        if (this.startTimestamp != null) {
            out.writeObject(this.startTimestamp);
        }
        if (this.stopTimestamp != null) {
            out.writeObject(this.stopTimestamp);
        }
        if (this.lastAccessTime != null) {
            out.writeObject(this.lastAccessTime);
        }
        if (this.timeout != 0L) {
            out.writeLong(this.timeout);
        }
        if (this.expired) {
            out.writeBoolean(this.expired);
        }
        if (this.host != null) {
            out.writeUTF(this.host);
        }
        if (!CollectionUtils.isEmpty(this.attributes)) {
            out.writeObject(this.attributes);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        short bitMask = in.readShort();
        if (SessionWrapper.isFieldPresent(bitMask, ID_BIT_MASK)) {
            this.id = (Serializable)in.readObject();
        }
        if (SessionWrapper.isFieldPresent(bitMask, START_TIMESTAMP_BIT_MASK)) {
            this.startTimestamp = (Date)in.readObject();
        }
        if (SessionWrapper.isFieldPresent(bitMask, STOP_TIMESTAMP_BIT_MASK)) {
            this.stopTimestamp = (Date)in.readObject();
        }
        if (SessionWrapper.isFieldPresent(bitMask, LAST_ACCESS_TIME_BIT_MASK)) {
            this.lastAccessTime = (Date)in.readObject();
        }
        if (SessionWrapper.isFieldPresent(bitMask, TIMEOUT_BIT_MASK)) {
            this.timeout = in.readLong();
        }
        if (SessionWrapper.isFieldPresent(bitMask, EXPIRED_BIT_MASK)) {
            this.expired = in.readBoolean();
        }
        if (SessionWrapper.isFieldPresent(bitMask, HOST_BIT_MASK)) {
            this.host = in.readUTF();
        }
        if (SessionWrapper.isFieldPresent(bitMask, ATTRIBUTES_BIT_MASK)) {
            this.attributes = (Map)in.readObject();
        }
    }

    private short getAlteredFieldsBitMask() {
        int bitMask = 0;
        bitMask = this.id != null ? bitMask | ID_BIT_MASK : bitMask;
        bitMask = this.startTimestamp != null ? bitMask | START_TIMESTAMP_BIT_MASK : bitMask;
        bitMask = this.stopTimestamp != null ? bitMask | STOP_TIMESTAMP_BIT_MASK : bitMask;
        bitMask = this.lastAccessTime != null ? bitMask | LAST_ACCESS_TIME_BIT_MASK : bitMask;
        bitMask = this.timeout != 0L ? bitMask | TIMEOUT_BIT_MASK : bitMask;
        bitMask = this.expired ? bitMask | EXPIRED_BIT_MASK : bitMask;
        bitMask = this.host != null ? bitMask | HOST_BIT_MASK : bitMask;
        bitMask = !CollectionUtils.isEmpty(this.attributes) ? bitMask | ATTRIBUTES_BIT_MASK : bitMask;
        return (short)bitMask;
    }

    private static boolean isFieldPresent(short bitMask, int fieldBitMask) {
        return (bitMask & fieldBitMask) != 0;
    }
}

