/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.shiro;

import com.github.fartherp.shiro.ClearCache;
import com.github.fartherp.shiro.CodecType;
import com.github.fartherp.shiro.ExpireType;
import com.github.fartherp.shiro.LocalDateTimeUtilies;
import com.github.fartherp.shiro.RedisCacheManager;
import com.github.fartherp.shiro.SessionWrapper;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.apache.shiro.util.Assert;
import org.apache.shiro.util.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RScoredSortedSet;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.ScoredEntry;

public class RedisSessionDAO
extends AbstractSessionDAO {
    private final String sessionKeyPrefix;
    private final int expire;
    private final boolean sessionInMemoryEnabled;
    private final long sessionInMemoryTimeout;
    private final Codec codec;
    private static final FastThreadLocal<Map<Serializable, SessionWrapper>> SESSIONS_IN_THREAD = new FastThreadLocal();
    private final RedisCacheManager redisCacheManager;
    private final RScoredSortedSet<String> sessionKeys;
    private final ClearCache clearCache;
    private final Map<String, Object> lruMap;

    public RedisSessionDAO(RedisCacheManager redisCacheManager) {
        this(redisCacheManager, "shiro:session", ExpireType.DEFAULT_EXPIRE, true, 1000L, CodecType.FST_CODEC, 1024);
    }

    public RedisSessionDAO(RedisCacheManager redisCacheManager, String sessionKeyPrefix, ExpireType expireType, boolean sessionInMemoryEnabled, long sessionInMemoryTimeout, CodecType codecType, int sessionLruSize) {
        Assert.notNull((Object)redisCacheManager, (String)"redisCacheManager is no null");
        this.redisCacheManager = redisCacheManager;
        this.sessionKeyPrefix = StringUtils.hasText((String)sessionKeyPrefix) ? sessionKeyPrefix : "shiro:session";
        this.expire = expireType != null ? expireType.type : ExpireType.DEFAULT_EXPIRE.type;
        this.sessionInMemoryEnabled = sessionInMemoryEnabled;
        this.sessionInMemoryTimeout = sessionInMemoryTimeout > 0L ? sessionInMemoryTimeout : 1000L;
        this.codec = codecType != null ? codecType.getCodec() : CodecType.FST_CODEC.getCodec();
        int tmpSessionLruSize = sessionLruSize > 0 ? sessionLruSize : 1024;
        this.lruMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)tmpSessionLruSize).weigher(Weighers.singleton()).build();
        this.sessionKeys = this.redisCacheManager.getRedissonClient().getScoredSortedSet(this.sessionKeyPrefix, CodecType.STRING_CODEC.getCodec());
        this.clearCache = new ClearCache(this);
        this.clearCache.run();
    }

    private <T> T convertLruMap(String key, Function<String, T> function) {
        return (T)this.lruMap.computeIfAbsent(key, function);
    }

    private <T> RBucket<T> getBucket(String redisSessionKey) {
        return this.convertLruMap(redisSessionKey, k -> this.redisCacheManager.getRedissonClient().getBucket(k, this.codec));
    }

    private String getRedisSessionKey(Serializable sessionId) {
        return this.sessionKeyPrefix + ":" + sessionId;
    }

    protected Serializable doCreate(Session session) {
        if (session == null) {
            throw new UnknownSessionException("session is null");
        }
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    private void saveSession(Session session) throws UnknownSessionException {
        long timestamp;
        if (session == null || session.getId() == null) {
            throw new UnknownSessionException("session or session id is null");
        }
        SessionWrapper sessionWrapper = new SessionWrapper();
        sessionWrapper.setSession(session);
        String key = this.getRedisSessionKey(sessionWrapper.getId());
        RBucket s = this.getBucket(key);
        if (this.expire == ExpireType.DEFAULT_EXPIRE.type) {
            long milliSeconds = sessionWrapper.getTimeout();
            s.set((Object)sessionWrapper, milliSeconds, TimeUnit.MILLISECONDS);
            timestamp = LocalDateTimeUtilies.getTimestamp(o -> o.plusNanos(milliSeconds * 1000000L));
        } else if (this.expire == ExpireType.CUSTOM_EXPIRE.type) {
            long milliSeconds = this.redisCacheManager.getTtl();
            s.set((Object)sessionWrapper, milliSeconds, TimeUnit.MILLISECONDS);
            timestamp = LocalDateTimeUtilies.getTimestamp(o -> o.plusNanos(milliSeconds * 1000000L));
        } else {
            s.set((Object)sessionWrapper);
            timestamp = Long.MAX_VALUE;
        }
        this.sessionKeys.add((double)timestamp, (Object)key);
    }

    protected Session doReadSession(Serializable sessionId) {
        Session session;
        if (sessionId == null) {
            return null;
        }
        if (this.sessionInMemoryEnabled && (session = this.getSessionFromThreadLocal(sessionId)) != null) {
            return session;
        }
        String key = this.getRedisSessionKey(sessionId);
        RBucket s = this.getBucket(key);
        session = Optional.ofNullable(s.get()).map(SessionWrapper::getSession).orElse(null);
        if (this.sessionInMemoryEnabled) {
            this.setSessionToThreadLocal(sessionId, session);
        }
        return session;
    }

    public void update(Session session) throws UnknownSessionException {
        this.saveSession(session);
        if (this.sessionInMemoryEnabled) {
            this.setSessionToThreadLocal(session.getId(), session);
        }
    }

    public void delete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        String key = this.getRedisSessionKey(session.getId());
        RBucket s = this.getBucket(key);
        s.delete();
        this.sessionKeys.remove((Object)key);
    }

    public Collection<Session> getActiveSessions() {
        List keys = (List)this.sessionKeys.entryRange((double)System.currentTimeMillis(), false, Double.MAX_VALUE, true);
        ArrayList<Session> values = new ArrayList<Session>(keys.size());
        for (ScoredEntry key : keys) {
            RBucket v = this.getBucket((String)key.getValue());
            SessionWrapper sessionWrapper = (SessionWrapper)v.get();
            if (sessionWrapper == null) continue;
            values.add(sessionWrapper.getSession());
        }
        return Collections.unmodifiableList(values);
    }

    private void setSessionToThreadLocal(Serializable sessionId, Session s) {
        if (s == null) {
            return;
        }
        HashMap<Serializable, SessionWrapper> sessionMap = (HashMap<Serializable, SessionWrapper>)SESSIONS_IN_THREAD.get();
        if (sessionMap == null) {
            sessionMap = new HashMap<Serializable, SessionWrapper>(4);
            SESSIONS_IN_THREAD.set(sessionMap);
        }
        SessionWrapper sessionWrapper = new SessionWrapper();
        sessionWrapper.setCreateTime(new Date());
        sessionWrapper.setSession(s);
        sessionMap.put(sessionId, sessionWrapper);
    }

    private Session getSessionFromThreadLocal(Serializable sessionId) {
        Map sessionMap = (Map)SESSIONS_IN_THREAD.get();
        if (sessionMap == null) {
            return null;
        }
        SessionWrapper sessionWrapper = (SessionWrapper)sessionMap.get(sessionId);
        if (sessionWrapper == null) {
            return null;
        }
        long duration = System.currentTimeMillis() - sessionWrapper.getCreateTime().getTime();
        Session s = null;
        if (duration < this.sessionInMemoryTimeout) {
            s = sessionWrapper.getSession();
        } else {
            sessionMap.remove(sessionId);
        }
        return s;
    }

    public String getSessionKeyPrefix() {
        return this.sessionKeyPrefix;
    }

    public int getExpire() {
        return this.expire;
    }

    public boolean isSessionInMemoryEnabled() {
        return this.sessionInMemoryEnabled;
    }

    public long getSessionInMemoryTimeout() {
        return this.sessionInMemoryTimeout;
    }

    public RedisCacheManager getRedisCacheManager() {
        return this.redisCacheManager;
    }

    public RScoredSortedSet<String> getSessionKeys() {
        return this.sessionKeys;
    }
}

