/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.shiro;

import com.github.fartherp.shiro.CodecType;
import com.github.fartherp.shiro.RedisCache;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.util.Map;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.util.Assert;
import org.apache.shiro.util.StringUtils;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;

public class RedisCacheManager
implements CacheManager {
    private final Map<String, Cache> caches;
    private final String keyPrefix;
    private final long ttl;
    private final int cacheLruSize;
    private final Codec cacheCodec;
    private final Codec cacheKeysCodec;
    private final RedissonClient redissonClient;

    public RedisCacheManager(RedissonClient redissonClient) {
        this(redissonClient, "shiro:cache:", 1800000L, 1024, CodecType.FST_CODEC, CodecType.FST_CODEC);
    }

    public RedisCacheManager(RedissonClient redissonClient, String keyPrefix, long ttl, int cacheLruSize, CodecType cacheCodecType, CodecType cacheKeysCodecType) {
        Assert.notNull((Object)redissonClient, (String)"RedissonClient is no null");
        this.redissonClient = redissonClient;
        this.keyPrefix = StringUtils.hasText((String)keyPrefix) ? keyPrefix : "shiro:cache:";
        this.ttl = ttl > 0L ? ttl : 1800000L;
        this.cacheLruSize = cacheLruSize > 0 ? cacheLruSize : 1024;
        this.cacheCodec = cacheCodecType != null ? cacheCodecType.getCodec() : CodecType.FST_CODEC.getCodec();
        this.cacheKeysCodec = cacheKeysCodecType != null ? cacheKeysCodecType.getCodec() : CodecType.FST_CODEC.getCodec();
        this.caches = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.cacheLruSize).weigher(Weighers.singleton()).build();
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        return this.caches.computeIfAbsent(name, k -> new RedisCache(this, this.keyPrefix + name, this.cacheLruSize, this.cacheKeysCodec));
    }

    public Map<String, Cache> getCaches() {
        return this.caches;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Codec getCacheCodec() {
        return this.cacheCodec;
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }
}

