/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.shiro;

import com.github.fartherp.shiro.LocalDateTimeUtilies;
import com.github.fartherp.shiro.RedisCacheManager;
import com.github.fartherp.shiro.ShiroFieldAccess;
import com.github.fartherp.shiro.exception.CachePrincipalNotImplementsAssignedException;
import com.github.fartherp.shiro.exception.PrincipalNullException;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.Assert;
import org.redisson.api.RBucket;
import org.redisson.api.RScoredSortedSet;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.ScoredEntry;

public class RedisCache<K, V>
implements Cache<K, V> {
    private final RedisCacheManager redisCacheManager;
    private final String cacheKeyPrefix;
    private final RScoredSortedSet<K> cacheKeys;
    private final Map<String, Object> lruMap;

    public RedisCache(RedisCacheManager redisCacheManager, String keyPrefix, int cacheLruSize, Codec cacheKeysCodec) {
        Assert.notNull((Object)redisCacheManager, (String)"redisCacheManager is no null");
        this.redisCacheManager = redisCacheManager;
        this.cacheKeyPrefix = keyPrefix;
        this.cacheKeys = redisCacheManager.getRedissonClient().getScoredSortedSet(this.cacheKeyPrefix, cacheKeysCodec);
        this.lruMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)cacheLruSize).weigher(Weighers.singleton()).build();
    }

    private String getRedisCacheKey(K key) {
        StringBuilder sb = new StringBuilder(this.cacheKeyPrefix);
        sb.append(':');
        if (key instanceof PrincipalCollection) {
            sb.append(this.getRedisKeyFromPrincipalUnique((PrincipalCollection)key));
        } else {
            sb.append(key);
        }
        return sb.toString();
    }

    private String getRedisKeyFromPrincipalUnique(PrincipalCollection key) {
        Object principalObject = key.getPrimaryPrincipal();
        if (principalObject == null) {
            throw new PrincipalNullException();
        }
        if (principalObject instanceof ShiroFieldAccess) {
            return ((ShiroFieldAccess)principalObject).unique();
        }
        throw new CachePrincipalNotImplementsAssignedException(principalObject.getClass());
    }

    private <T> T convertLruMap(String key, Function<String, T> function) {
        return (T)this.lruMap.computeIfAbsent(key, function);
    }

    private RBucket<V> getBucket(K key) {
        return this.convertLruMap(this.getRedisCacheKey(key), k -> this.redisCacheManager.getRedissonClient().getBucket(k, this.redisCacheManager.getCacheCodec()));
    }

    public V get(K key) throws CacheException {
        RBucket<V> v = this.getBucket(key);
        return (V)v.get();
    }

    public V put(K key, V value) throws CacheException {
        RBucket<V> v = this.getBucket(key);
        long ttl = this.redisCacheManager.getTtl();
        v.set(value, ttl, TimeUnit.MILLISECONDS);
        this.cacheKeys.add((double)LocalDateTimeUtilies.getTimestamp(o -> o.plusNanos(ttl * 1000000L)), key);
        return value;
    }

    public V remove(K key) throws CacheException {
        RBucket<V> v = this.getBucket(key);
        Object value = v.get();
        v.delete();
        this.cacheKeys.remove(key);
        return (V)value;
    }

    public void clear() throws CacheException {
        for (Object key : this.cacheKeys) {
            RBucket<V> v = this.getBucket(key);
            v.delete();
        }
        this.cacheKeys.delete();
    }

    public int size() {
        List keys = (List)this.cacheKeys.entryRange((double)System.currentTimeMillis(), false, Double.MAX_VALUE, true);
        return keys.size();
    }

    public Set<K> keys() {
        List keys = (List)this.cacheKeys.entryRange((double)System.currentTimeMillis(), false, Double.MAX_VALUE, true);
        return keys.stream().map(ScoredEntry::getValue).collect(Collectors.toSet());
    }

    public Collection<V> values() {
        List keys = (List)this.cacheKeys.entryRange((double)System.currentTimeMillis(), false, Double.MAX_VALUE, true);
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (ScoredEntry key : keys) {
            RBucket<V> v = this.getBucket(key.getValue());
            Object value = v.get();
            if (value == null) continue;
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    public RScoredSortedSet<K> getCacheKeys() {
        return this.cacheKeys;
    }
}

