/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.shiro;

import com.github.fartherp.shiro.RedisCache;
import com.github.fartherp.shiro.RedisSessionDAO;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shiro.cache.Cache;
import org.redisson.api.RScoredSortedSet;
import org.redisson.client.protocol.ScoredEntry;

public class ClearCache
implements TimerTask {
    private final HashedWheelTimer hashedWheelTimer = new HashedWheelTimer();
    private final RedisSessionDAO redisSessionDAO;

    ClearCache(RedisSessionDAO redisSessionDAO) {
        this.redisSessionDAO = redisSessionDAO;
    }

    void run() {
        long currentTimeMillis = System.currentTimeMillis();
        this.clearSession(currentTimeMillis);
        this.clearCache(currentTimeMillis);
        this.hashedWheelTimer.newTimeout((TimerTask)this, this.redisSessionDAO.getRedisCacheManager().getTtl(), TimeUnit.MILLISECONDS);
    }

    void clearSession(long currentTimeMillis) {
        RScoredSortedSet<String> sessionKeys = this.redisSessionDAO.getSessionKeys();
        this.removeAll(sessionKeys, o -> (List)o.entryRange(0.0, false, (double)currentTimeMillis, true));
    }

    void clearCache(long currentTimeMillis) {
        Map<String, Cache> caches = this.redisSessionDAO.getRedisCacheManager().getCaches();
        caches.forEach((k, v) -> {
            RedisCache redisCache = (RedisCache)v;
            RScoredSortedSet cacheKeys = redisCache.getCacheKeys();
            this.removeAll(cacheKeys, o -> (List)o.entryRange(0.0, false, (double)currentTimeMillis, true));
        });
    }

    private void removeAll(RScoredSortedSet rScoredSortedSet, Function<RScoredSortedSet, List<ScoredEntry>> fun) {
        List<ScoredEntry> keys = fun.apply(rScoredSortedSet);
        List destroyKeys = keys.stream().map(ScoredEntry::getValue).collect(Collectors.toList());
        if (destroyKeys.size() > 0) {
            rScoredSortedSet.removeAll(destroyKeys);
        }
    }

    public void run(Timeout timeout) throws Exception {
        this.run();
    }
}

