/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.template;

import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.notify.Notify;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.base.sms.SmsInfo;
import com.gexin.rp.sdk.dto.GtReq;
import com.gexin.rp.sdk.template.APNTemplate;
import com.gexin.rp.sdk.template.IncTemplate;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.NotyPopLoadTemplate;
import com.gexin.rp.sdk.template.PopupTransmissionTemplate;
import com.gexin.rp.sdk.template.RevokeTemplate;
import com.gexin.rp.sdk.template.StartActivityTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AbstractTemplate
implements ITemplate {
    private String appId;
    private String appkey;
    private GtReq.PushInfo.Builder pushInfo = GtReq.PushInfo.newBuilder().setInvalidAPN(true).setInvalidMPN(true);
    private GtReq.SmsInfo smsInfo = null;
    private String duration;
    private GtReq.Transparent transparent = null;
    private static final Pattern pattern = Pattern.compile("^(intent:).*(;end)$");
    public static final String notification = "notification";

    public GtReq.Transparent getTransparent() {
        if (this.transparent == null) {
            GtReq.Transparent.Builder builder = GtReq.Transparent.newBuilder().setTemplateId(this.getTemplateId()).setId("").setMessageId("").setTaskId("").setAction("pushmessage").addAllActionChain(this.getActionChain()).setPushInfo(this.pushInfo).setAppId(this.appId).setAppKey(this.appkey).addCondition(this.getDurCondition());
            if (this.smsInfo != null) {
                builder.setSmsInfo(this.smsInfo);
            }
            this.transparent = builder.build();
        }
        return this.transparent;
    }

    private String getDurCondition() {
        if (this.duration != null && this.duration.length() > 0) {
            return "duration=" + this.duration;
        }
        return "";
    }

    public String getTransmissionContent() {
        return "";
    }

    public String getPushType() {
        return "";
    }

    protected List<GtReq.ActionChain> getActionChain() {
        return null;
    }

    public GtReq.PushInfo getPushInfo() {
        return this.pushInfo.build();
    }

    protected GtReq.PushInfo.Builder getPushInfoBuilder() {
        return this.pushInfo;
    }

    @Deprecated
    public void setPushInfo(String actionLocKey, int badge, String message, String sound) {
        APNPayload apn = new APNPayload();
        APNPayload.DictionaryAlertMsg alertMessage = new APNPayload.DictionaryAlertMsg();
        alertMessage.setActionLocKey(actionLocKey);
        alertMessage.setBody(message);
        apn.setAlertMsg((APNPayload.AlertMsg)alertMessage);
        apn.setBadge(badge);
        apn.setSound(sound);
        this.setAPNInfo((Payload)apn);
    }

    @Deprecated
    public void setPushInfo(String actionLocKey, int badge, String message, String sound, String payload, String locKey, String locArgs, String launchImage) throws Exception {
        this.setPushInfo(actionLocKey, badge, message, sound, payload, locKey, locArgs, launchImage, 0);
    }

    @Deprecated
    public void setPushInfo(String actionLocKey, int badge, String message, String sound, String payload, String locKey, String locArgs, String launchImage, Integer contentAvailable) throws Exception {
        APNPayload apn = new APNPayload();
        APNPayload.DictionaryAlertMsg alertMsg = new APNPayload.DictionaryAlertMsg();
        alertMsg.setActionLocKey(actionLocKey);
        alertMsg.setBody(message);
        alertMsg.setLocKey(locKey);
        alertMsg.addLocArg(locArgs);
        alertMsg.setLaunchImage(launchImage);
        apn.setAlertMsg((APNPayload.AlertMsg)alertMsg);
        apn.setBadge(badge);
        apn.setSound(sound);
        apn.addCustomMsg("payload", (Object)payload);
        apn.setContentAvailable(contentAvailable.intValue());
        this.setAPNInfo((Payload)apn);
    }

    public void setSmsInfo(SmsInfo smsInfo) {
        if (smsInfo == null) {
            throw new RuntimeException("smsInfo cannot be empty");
        }
        String smsTemplateId = smsInfo.getSmsTemplateId();
        Map smsContent = smsInfo.getSmsContent();
        Long offlineSendtime = smsInfo.getOfflineSendtime();
        Long smsSendDuration = 0L;
        if (smsTemplateId == null || smsTemplateId.isEmpty()) {
            throw new RuntimeException("smsTemplateId cannot be empty");
        }
        if (offlineSendtime == null) {
            throw new RuntimeException("offlineSendtime cannot be empty");
        }
        GtReq.SmsInfo.Builder builder = GtReq.SmsInfo.newBuilder().setSmsChecked(false).setSmsTemplateId(smsTemplateId).setOfflineSendtime(offlineSendtime.longValue());
        if (smsInfo.isApplink()) {
            if (smsInfo.getSmsContent() != null && smsInfo.getSmsContent().get("url") != null) {
                throw new RuntimeException("SmsContent cann not contains key about url");
            }
            builder.addSmsContent(GtReq.SmsContentEntry.newBuilder().setKey("applinkIdentification").setValue("1"));
            String payload = smsInfo.getPayload();
            if (payload == null || payload.isEmpty()) {
                builder.addSmsContent(GtReq.SmsContentEntry.newBuilder().setKey("url").setValue(smsInfo.getUrl() + "?p="));
            } else {
                builder.addSmsContent(GtReq.SmsContentEntry.newBuilder().setKey("url").setValue(smsInfo.getUrl() + "?n=" + payload + "&p="));
            }
        }
        if (smsContent != null) {
            for (Map.Entry entry : smsContent.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key != null && !key.isEmpty() && value != null) {
                    builder.addSmsContent(GtReq.SmsContentEntry.newBuilder().setKey(key).setValue(value));
                    continue;
                }
                throw new RuntimeException("smsContent entry cannot be null");
            }
        }
        if (smsSendDuration != null) {
            builder.setSmsSendDuration(smsSendDuration.longValue());
        }
        this.smsInfo = builder.build();
    }

    public void setAPNInfo(Payload apn) {
        if (apn == null) {
            return;
        }
        String payload = apn.getPayload();
        if (payload == null || payload.isEmpty()) {
            return;
        }
        try {
            int length = payload.getBytes("UTF-8").length;
            if (length > 3072) {
                throw new RuntimeException("APN payload size overlength (" + length + ">" + 3072 + ")");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.pushInfo.setApnJson(payload).setInvalidAPN(false);
    }

    public void set3rdNotifyInfo(Notify notify) {
        List extKVList;
        GtReq.NotifyInfo.Builder notifyInfo = GtReq.NotifyInfo.newBuilder().setTitle(notify.getTitle()).setContent(notify.getContent());
        if (notify.getType() != null) {
            notifyInfo.setType(notify.getType());
            if (notify.getPayload() != null && notify.getPayload().length() > 0) {
                notifyInfo.setPayload(notify.getPayload());
            }
            if (notify.getIntent() != null && notify.getIntent().length() > 0) {
                if (notify.getIntent().length() > Integer.parseInt(System.getProperty("TransmissionTemplate.intent.length", "1000"))) {
                    throw new RuntimeException("intent size overlimit " + System.getProperty("TransmissionTemplate.intent.length", "1000"));
                }
                if (!pattern.matcher(notify.getIntent()).find()) {
                    throw new RuntimeException("intent format error,should start with \"intent:\",end with \";end\" ");
                }
                notifyInfo.setIntent(notify.getIntent());
            }
            if (notify.getUrl() != null && notify.getUrl().length() > 0) {
                notifyInfo.setUrl(notify.getUrl());
            }
        }
        if (notify.getNotifyId() != null) {
            notifyInfo.setNotifyId(String.valueOf(notify.getNotifyId()));
        }
        if ((extKVList = notify.getExtKVList()) != null) {
            for (Notify.ExtKV extKV : extKVList) {
                notifyInfo.addExtKV(GtReq.ExtKV.newBuilder().setConstains(extKV.getConstrains().name()).setKey(extKV.getKey()).setValue(extKV.getValue()).build());
            }
        }
        this.pushInfo.setNotifyInfo(notifyInfo).setValidNotify(true);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String begin, String end) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long s = sdf.parse(begin).getTime();
        long e = sdf.parse(end).getTime();
        if (s <= 0L || e <= 0L) {
            throw new Exception("DateFormat: yyyy-MM-dd HH:mm:ss");
        }
        if (s > e) {
            throw new Exception("startTime should be smaller than endTime");
        }
        this.duration = s + "-" + e;
    }

    public int getTemplateId() {
        if (this instanceof NotificationTemplate) {
            return 0;
        }
        if (this instanceof LinkTemplate) {
            return 1;
        }
        if (this instanceof NotyPopLoadTemplate) {
            return 2;
        }
        if (this instanceof PopupTransmissionTemplate) {
            return 3;
        }
        if (this instanceof TransmissionTemplate) {
            return 4;
        }
        if (this instanceof APNTemplate) {
            return 5;
        }
        if (this instanceof IncTemplate) {
            return 6;
        }
        if (this instanceof StartActivityTemplate) {
            return 7;
        }
        if (this instanceof RevokeTemplate) {
            return 8;
        }
        return -1;
    }
}

