/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet.utils;

import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientIPUtils {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public static String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = ClientIPUtils.parseRemoteAddr(request.getHeader(HttpHeader.X_FORWARDED_FOR.asString()));
        if (remoteAddr != null) {
            return remoteAddr;
        }
        return request.getRemoteAddr();
    }

    public static String parseRemoteAddr(String remoteAddr) {
        try {
            if (VerifyUtils.isNotEmpty((String)remoteAddr)) {
                if (remoteAddr.contains(",")) {
                    String[] array;
                    for (String element : array = StringUtils.split((String)remoteAddr, (char)',')) {
                        String addr = element.trim();
                        if ("unknown".equalsIgnoreCase(addr)) continue;
                        return addr;
                    }
                    return null;
                }
                return remoteAddr.trim();
            }
            return null;
        }
        catch (Throwable e) {
            log.error("parse romote ip error", e);
            return null;
        }
    }
}

