/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet.session;

import com.firefly.server.http2.servlet.session.HttpSessionImpl;
import com.firefly.server.http2.servlet.session.HttpSessionManager;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.time.HashTimeWheel;
import com.firefly.utils.time.Millisecond100Clock;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHttpSessionManager
extends AbstractLifeCycle
implements HttpSessionManager {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private ConcurrentHashMap<String, HttpSessionImpl> map = new ConcurrentHashMap();
    private int maxSessionInactiveInterval = 600;
    private HttpSessionAttributeListener httpSessionAttributeListener = new HttpSessionManager.HttpSessionAttributeListenerAdapter();
    private HttpSessionListener httpSessionListener = new HttpSessionManager.HttpSessionListenerAdapter();
    private static final HashTimeWheel TIME_WHEEL = new HashTimeWheel();

    public LocalHttpSessionManager() {
        this.start();
    }

    @Override
    public boolean containsKey(String id) {
        return this.map.containsKey(id);
    }

    @Override
    public HttpSession remove(String id) {
        HttpSession session = this.map.remove(id);
        if (session != null) {
            this.httpSessionListener.sessionDestroyed(new HttpSessionEvent(session));
        }
        return session;
    }

    @Override
    public HttpSession get(String id) {
        return this.map.get(id);
    }

    @Override
    public HttpSession create() {
        String id = UUID.randomUUID().toString().replace("-", "");
        long timeout = this.maxSessionInactiveInterval * 1000;
        HttpSessionImpl session = new HttpSessionImpl(this, id, Millisecond100Clock.currentTimeMillis(), this.maxSessionInactiveInterval);
        TIME_WHEEL.add(timeout, (Runnable)new TimeoutTask(session));
        this.map.put(id, session);
        this.httpSessionListener.sessionCreated(new HttpSessionEvent((HttpSession)session));
        return session;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int getMaxSessionInactiveInterval() {
        return this.maxSessionInactiveInterval;
    }

    @Override
    public void setMaxSessionInactiveInterval(int maxSessionInactiveInterval) {
        this.maxSessionInactiveInterval = maxSessionInactiveInterval;
    }

    @Override
    public HttpSessionAttributeListener getHttpSessionAttributeListener() {
        return this.httpSessionAttributeListener;
    }

    @Override
    public void setHttpSessionAttributeListener(HttpSessionAttributeListener httpSessionAttributeListener) {
        this.httpSessionAttributeListener = httpSessionAttributeListener;
    }

    @Override
    public HttpSessionListener getHttpSessionListener() {
        return this.httpSessionListener;
    }

    @Override
    public void setHttpSessionListener(HttpSessionListener httpSessionListener) {
        this.httpSessionListener = httpSessionListener;
    }

    protected void init() {
        TIME_WHEEL.start();
    }

    protected void destroy() {
        TIME_WHEEL.stop();
    }

    private class TimeoutTask
    implements Runnable {
        private HttpSessionImpl session;

        public TimeoutTask(HttpSessionImpl session) {
            this.session = session;
        }

        @Override
        public void run() {
            long timeDifference = Millisecond100Clock.currentTimeMillis() - this.session.getLastAccessedTime();
            long timeout = this.session.getMaxInactiveInterval() * 1000;
            log.debug("the local session timeout is {}, the time difference is {}", (Object)timeout, (Object)timeDifference);
            if (timeDifference > timeout) {
                log.debug("removes local session {}", (Object)this.session.getId());
                LocalHttpSessionManager.this.remove(this.session.getId());
            } else if (timeout > 0L) {
                long nextCheckTime = timeout - timeDifference;
                TIME_WHEEL.add(nextCheckTime, (Runnable)this);
            } else if (timeout == 0L) {
                LocalHttpSessionManager.this.remove(this.session.getId());
            }
        }
    }
}

