/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet.session;

import com.firefly.server.exception.HttpServerException;
import com.firefly.server.http2.servlet.session.HttpSessionManager;
import com.firefly.utils.time.Millisecond100Clock;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
implements HttpSession {
    private static final String[] EMPTY_ARR = new String[0];
    private final HttpSessionManager sessionManager;
    private final String id;
    private final long creationTime;
    private volatile long lastAccessedTime;
    private volatile int maxInactiveInterval;
    private ConcurrentHashMap<String, Object> map = new ConcurrentHashMap();

    public HttpSessionImpl(HttpSessionManager sessionManager, String id, long creationTime, int maxInactiveInterval) {
        this.sessionManager = sessionManager;
        this.id = id;
        this.creationTime = creationTime;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public ServletContext getServletContext() {
        throw new HttpServerException("no implements this method!");
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        throw new HttpServerException("no implements this method!");
    }

    public Object getAttribute(String name) {
        this.lastAccessedTime = Millisecond100Clock.currentTimeMillis();
        return this.map.get(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.lastAccessedTime = Millisecond100Clock.currentTimeMillis();
        return this.map.keys();
    }

    public String[] getValueNames() {
        this.lastAccessedTime = Millisecond100Clock.currentTimeMillis();
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray(EMPTY_ARR);
    }

    public void setAttribute(String name, Object value) {
        this.lastAccessedTime = Millisecond100Clock.currentTimeMillis();
        Object v = this.map.put(name, value);
        if (v == null) {
            this.sessionManager.getHttpSessionAttributeListener().attributeAdded(new HttpSessionBindingEvent((HttpSession)this, name, value));
        } else {
            this.sessionManager.getHttpSessionAttributeListener().attributeReplaced(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.lastAccessedTime = Millisecond100Clock.currentTimeMillis();
        Object value = this.map.remove(name);
        if (value != null) {
            this.sessionManager.getHttpSessionAttributeListener().attributeRemoved(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.sessionManager.remove(this.id);
    }

    public boolean isNew() {
        return this.lastAccessedTime > 0L;
    }
}

