/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet;

import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.mvc.web.servlet.HttpServletDispatcherController;
import com.firefly.server.http2.ServerHTTPHandler;
import com.firefly.server.http2.servlet.AsyncContextImpl;
import com.firefly.server.http2.servlet.HTTPServletRequestImpl;
import com.firefly.server.http2.servlet.ServerHTTP2Configuration;
import com.firefly.server.http2.servlet.utils.ClientIPUtils;
import com.firefly.server.utils.StatisticsUtils;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.time.Millisecond100Clock;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletServerHTTPHandler
extends ServerHTTPHandler.Adapter {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final ServerHTTP2Configuration http2Configuration;
    private final HttpServletDispatcherController controller;

    public ServletServerHTTPHandler(ServerHTTP2Configuration http2Configuration, HttpServletDispatcherController controller) {
        this.http2Configuration = http2Configuration;
        this.controller = controller;
        AsyncContextImpl.init(http2Configuration);
    }

    @Override
    public boolean headerComplete(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
        response.setHttpVersion(request.getHttpVersion());
        HTTPServletRequestImpl servletRequest = new HTTPServletRequestImpl(this.http2Configuration, request, response, output, connection);
        request.setAttachment(servletRequest);
        return false;
    }

    @Override
    public boolean content(ByteBuffer item, MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
        HTTPServletRequestImpl servletRequest = (HTTPServletRequestImpl)request.getAttachment();
        try {
            servletRequest.getBodyPipedStream().getOutputStream().write(BufferUtils.toArray((ByteBuffer)item));
        }
        catch (IOException e) {
            log.error("receive http body data exception", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean messageComplete(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
        long start = Millisecond100Clock.currentTimeMillis();
        try (HTTPServletRequestImpl servletRequest = (HTTPServletRequestImpl)request.getAttachment();){
            servletRequest.completeDataReceiving();
            this.controller.dispatch(servletRequest, servletRequest.getResponse());
        }
        long timeDifference = Millisecond100Clock.currentTimeMillis() - start;
        StatisticsUtils.saveRequestInfo(connection.getSessionId(), this.getRemoteAddr(request, connection), request.getMethod(), request.getURI(), timeDifference);
        return true;
    }

    @Override
    public void badMessage(int status, String reason, MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
        HTTPServletRequestImpl servletRequest = (HTTPServletRequestImpl)request.getAttachment();
        if (servletRequest.getResponse().isCommitted()) {
            log.error("receive the bad message, status: {}, reason: {}", (Object)status, (Object)reason);
        } else {
            try {
                servletRequest.getResponse().sendError(status, reason);
            }
            catch (IOException e) {
                log.error("response bad message exception", (Throwable)e);
            }
        }
    }

    private Object getRemoteAddr(MetaData.Request request, HTTPConnection connection) {
        String remoteAddr = ClientIPUtils.parseRemoteAddr(request.getFields().get(HttpHeader.X_FORWARDED_FOR));
        if (remoteAddr != null) {
            return remoteAddr;
        }
        if (connection.isOpen()) {
            return connection.getRemoteAddress();
        }
        return "null";
    }
}

