/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet;

import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.mvc.web.FileAccessFilter;
import com.firefly.server.http2.servlet.session.HttpSessionManager;
import com.firefly.server.http2.servlet.session.LocalHttpSessionManager;
import java.io.File;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerHTTP2Configuration
extends HTTP2Configuration {
    public static final String DEFAULT_CONFIG_FILE_NAME = "firefly.xml";
    private String host;
    private int port;
    private int httpBodyThreshold = 0x400000;
    private String temporaryDirectory = new File(System.getProperty("user.dir"), "temp").getAbsolutePath();
    private int servletResponseBufferSize = 8192;
    private MultipartConfigElement multipartConfigElement;
    private String configFileName = "firefly.xml";
    private String serverHome;
    private int maxRangeNum = 8;
    private Map<Integer, String> errorPage;
    private FileAccessFilter fileAccessFilter = new FileAccessFilter(){

        @Override
        public String doFilter(HttpServletRequest request, HttpServletResponse response, String path) {
            return path;
        }
    };
    private String sessionIdName = "jsessionid";
    private HttpSessionManager httpSessionManager = new LocalHttpSessionManager();
    private int asynchronousContextCorePoolSize = Runtime.getRuntime().availableProcessors();
    private int asynchronousContextMaximumPoolSize = 64;
    private int asynchronousContextCorePoolKeepAliveTime = 10000;
    private int asynchronousContextTimeout = 6000;

    public int getHttpBodyThreshold() {
        return this.httpBodyThreshold;
    }

    public void setHttpBodyThreshold(int httpBodyThreshold) {
        this.httpBodyThreshold = httpBodyThreshold;
    }

    public String getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public void setTemporaryDirectory(String temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
    }

    public int getServletResponseBufferSize() {
        return this.servletResponseBufferSize;
    }

    public void setServletResponseBufferSize(int servletResponseBufferSize) {
        this.servletResponseBufferSize = servletResponseBufferSize;
    }

    public MultipartConfigElement getMultipartConfigElement() {
        return this.multipartConfigElement;
    }

    public MultipartConfigElement getDefaultMultipartConfigElement() {
        if (this.multipartConfigElement != null) {
            return this.multipartConfigElement;
        }
        this.multipartConfigElement = new MultipartConfigElement(this.temporaryDirectory, -1L, -1L, this.httpBodyThreshold);
        return this.multipartConfigElement;
    }

    public void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public String getServerHome() {
        return this.serverHome;
    }

    public void setServerHome(String serverHome) {
        this.serverHome = serverHome;
    }

    public int getMaxRangeNum() {
        return this.maxRangeNum;
    }

    public void setMaxRangeNum(int maxRangeNum) {
        this.maxRangeNum = maxRangeNum;
    }

    public Map<Integer, String> getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(Map<Integer, String> errorPage) {
        this.errorPage = errorPage;
    }

    public FileAccessFilter getFileAccessFilter() {
        return this.fileAccessFilter;
    }

    public void setFileAccessFilter(FileAccessFilter fileAccessFilter) {
        this.fileAccessFilter = fileAccessFilter;
    }

    public String getSessionIdName() {
        return this.sessionIdName;
    }

    public void setSessionIdName(String sessionIdName) {
        this.sessionIdName = sessionIdName;
    }

    public HttpSessionManager getHttpSessionManager() {
        return this.httpSessionManager;
    }

    public void setHttpSessionManager(HttpSessionManager httpSessionManager) {
        this.httpSessionManager = httpSessionManager;
    }

    public int getAsynchronousContextCorePoolSize() {
        return this.asynchronousContextCorePoolSize;
    }

    public void setAsynchronousContextCorePoolSize(int asynchronousContextCorePoolSize) {
        this.asynchronousContextCorePoolSize = asynchronousContextCorePoolSize;
    }

    public int getAsynchronousContextMaximumPoolSize() {
        return this.asynchronousContextMaximumPoolSize;
    }

    public void setAsynchronousContextMaximumPoolSize(int asynchronousContextMaximumPoolSize) {
        this.asynchronousContextMaximumPoolSize = asynchronousContextMaximumPoolSize;
    }

    public int getAsynchronousContextCorePoolKeepAliveTime() {
        return this.asynchronousContextCorePoolKeepAliveTime;
    }

    public void setAsynchronousContextCorePoolKeepAliveTime(int asynchronousContextCorePoolKeepAliveTime) {
        this.asynchronousContextCorePoolKeepAliveTime = asynchronousContextCorePoolKeepAliveTime;
    }

    public int getAsynchronousContextTimeout() {
        return this.asynchronousContextTimeout;
    }

    public void setAsynchronousContextTimeout(int asynchronousContextTimeout) {
        this.asynchronousContextTimeout = asynchronousContextTimeout;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

