/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet;

import com.firefly.mvc.web.AnnotationWebContext;
import com.firefly.mvc.web.Resource;
import com.firefly.mvc.web.View;
import com.firefly.mvc.web.WebHandler;
import com.firefly.mvc.web.servlet.SystemHtmlPage;
import com.firefly.mvc.web.view.StaticFileView;
import com.firefly.mvc.web.view.TemplateView;
import com.firefly.server.http2.servlet.ServerHTTP2Configuration;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAnnotationWebContext
extends AnnotationWebContext {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final ServerHTTP2Configuration http2Configuration;

    public ServerAnnotationWebContext(String file) {
        super(file);
        this.http2Configuration = this.getBean(ServerHTTP2Configuration.class);
        this.http2Configuration.setConfigFileName(file);
        this.viewInit();
    }

    public ServerAnnotationWebContext(ServerHTTP2Configuration http2Configuration) {
        super(http2Configuration.getConfigFileName());
        this.http2Configuration = http2Configuration;
        this.viewInit();
    }

    private void viewInit() {
        SystemHtmlPage.addErrorPageMap(this.http2Configuration.getErrorPage());
        TemplateView.init(new File(this.http2Configuration.getServerHome(), this.getViewPath()).getAbsolutePath(), this.getEncoding());
        StaticFileView.init(this.http2Configuration.getCharacterEncoding(), this.http2Configuration.getFileAccessFilter(), this.http2Configuration.getServerHome(), this.http2Configuration.getMaxRangeNum(), this.getViewPath());
        this.http2Configuration.setCharacterEncoding(this.getEncoding());
        log.info("server home is {}", (Object)this.http2Configuration.getServerHome());
    }

    @Override
    protected void addLastHandler(String uri, String servletURI, AnnotationWebContext.HandlerChainImpl chain) {
        Resource.Result last = null;
        if (servletURI != null) {
            last = this.resource.match(servletURI);
        }
        if (last != null) {
            chain.add(last);
            return;
        }
        final String path = uri.equals("/") ? "/index.html" : uri;
        File file = new File(this.http2Configuration.getServerHome(), path);
        if (!file.exists() || file.isDirectory()) {
            return;
        }
        chain.add(new WebHandler(){

            @Override
            public View invoke(HttpServletRequest request, HttpServletResponse response) {
                return new StaticFileView(path);
            }
        });
    }
}

