/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet;

import com.firefly.codec.http2.model.CookieGenerator;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.BufferedHTTPOutputStream;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.mvc.web.servlet.SystemHtmlPage;
import com.firefly.server.exception.HttpServerException;
import com.firefly.server.http2.servlet.HTTPServletRequestImpl;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServletResponseImpl
implements HttpServletResponse {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final MetaData.Response response;
    private final HTTPOutputStream output;
    private final HTTPServletRequestImpl request;
    private String characterEncoding;
    private Locale locale;
    private int bufferSize;
    private ServletOutputStream servletOutputStream;
    private PrintWriter printWriter;

    public HTTPServletResponseImpl(MetaData.Response response, HTTPOutputStream output, HTTPServletRequestImpl request) {
        this.response = response;
        this.output = output;
        this.request = request;
        this.characterEncoding = request.http2Configuration.getCharacterEncoding();
        this.bufferSize = request.http2Configuration.getServletResponseBufferSize();
        response.setStatus(200);
    }

    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    public void setStatus(int status, String reason) {
        this.response.setStatus(status);
        this.response.setReason(reason);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public void sendError(int status, String reason) throws IOException {
        this.setStatus(status, reason);
        try (PrintWriter writer = this.getWriter();){
            writer.print(SystemHtmlPage.systemPageTemplate(status, ""));
        }
    }

    public void sendError(int status) throws IOException {
        this.setStatus(status);
        try (PrintWriter writer = this.getWriter();){
            writer.print(SystemHtmlPage.systemPageTemplate(status, ""));
        }
    }

    public void sendRedirect(String location) throws IOException {
        String absolute = this.toAbsolute(location);
        this.response.setStatus(302);
        this.response.getFields().put(HttpHeader.LOCATION, absolute);
        this.response.getFields().put(HttpHeader.CONTENT_LENGTH, "0");
        this.output.close();
    }

    private String toAbsolute(String location) {
        if (location.startsWith("http")) {
            return location;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.request.getScheme()).append("://").append(this.request.getServerName()).append(":").append(this.request.getServerPort());
        if (location.charAt(0) == '/') {
            sb.append(location);
        } else {
            String URI2 = this.request.getRequestURI();
            int last = 0;
            for (int i = URI2.length() - 1; i >= 0; --i) {
                if (URI2.charAt(i) != '/') continue;
                last = i + 1;
                break;
            }
            sb.append(URI2.substring(0, last)).append(location);
        }
        return sb.toString();
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String contentType) {
        this.response.getFields().put(HttpHeader.CONTENT_TYPE, contentType);
    }

    public String getContentType() {
        return this.response.getFields().get(HttpHeader.CONTENT_TYPE);
    }

    public void setContentLength(int len) {
        this.response.getFields().putLongField(HttpHeader.CONTENT_LENGTH, (long)len);
    }

    public void setContentLengthLong(long len) {
        this.response.getFields().putLongField(HttpHeader.CONTENT_LENGTH, len);
    }

    public void setLocale(Locale locale) {
        String contentLanguage;
        this.locale = locale;
        if (locale != null && VerifyUtils.isNotEmpty((String)(contentLanguage = locale.getLanguage()))) {
            String country = locale.getCountry();
            if (VerifyUtils.isNotEmpty((String)country)) {
                contentLanguage = contentLanguage + "-" + country;
            }
            this.response.getFields().put(HttpHeader.CONTENT_LANGUAGE, contentLanguage);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean containsHeader(String name) {
        return this.response.getFields().containsKey(name);
    }

    public void setDateHeader(String name, long date) {
        this.response.getFields().putDateField(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.response.getFields().addDateField(name, date);
    }

    public void setHeader(String name, String value) {
        this.response.getFields().put(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.getFields().add(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.getFields().putLongField(name, (long)value);
    }

    public void addIntHeader(String name, int value) {
        this.response.getFields().add(name, Integer.toString(value));
    }

    public String getHeader(String name) {
        return this.response.getFields().get(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.enumerationToCollection(this.response.getFields().getValues(name));
    }

    public Collection<String> getHeaderNames() {
        return this.enumerationToCollection(this.response.getFields().getFieldNames());
    }

    private <T> Collection<T> enumerationToCollection(Enumeration<T> enumeration) {
        if (enumeration == null) {
            return null;
        }
        LinkedList<T> list = new LinkedList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public void addCookie(Cookie cookie) {
        this.response.getFields().add(HttpHeader.SET_COOKIE, CookieGenerator.generateServletSetCookie(cookie));
    }

    public String encodeURL(String url) {
        if (VerifyUtils.isEmpty((String)url)) {
            return null;
        }
        if (url.contains(";" + this.request.http2Configuration.getSessionIdName() + "=")) {
            return url;
        }
        String absoluteURL = this.toAbsolute(url);
        String requestedSessionId = this.request.getRequestedSessionId();
        if (VerifyUtils.isNotEmpty((String)requestedSessionId)) {
            return this.toEncoded(absoluteURL, requestedSessionId, this.request.http2Configuration.getSessionIdName());
        }
        return null;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    private String toEncoded(String url, String sessionId, String sessionIdName) {
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(";");
            sb.append(sessionIdName);
            sb.append("=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public boolean isCommitted() {
        return this.output.isCommited();
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IOException("the response has used PrintWriter");
        }
        if (this.servletOutputStream == null) {
            this.servletOutputStream = new HTTPServletOutputStream();
            return this.servletOutputStream;
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.servletOutputStream != null) {
            throw new IOException("the response has used ServletOutputStream");
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)new HTTPServletOutputStream()), this.characterEncoding));
            return this.printWriter;
        }
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.flush();
            return;
        }
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
    }

    public void resetBuffer() {
        throw new HttpServerException("not implement this method!");
    }

    public void reset() {
        throw new HttpServerException("not implement this method!");
    }

    private class HTTPServletOutputStream
    extends ServletOutputStream {
        BufferedHTTPOutputStream bufferedHTTPOutputStream;

        private HTTPServletOutputStream() {
            this.bufferedHTTPOutputStream = new BufferedHTTPOutputStream(HTTPServletResponseImpl.this.output, HTTPServletResponseImpl.this.bufferSize);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            try {
                writeListener.onWritePossible();
            }
            catch (IOException e) {
                writeListener.onError((Throwable)e);
            }
        }

        public void write(int b) throws IOException {
            this.bufferedHTTPOutputStream.write(b);
        }

        public void write(byte[] array, int offset, int length) throws IOException {
            this.bufferedHTTPOutputStream.write(array, offset, length);
        }

        public void print(String s) throws IOException {
            if (VerifyUtils.isEmpty((String)s)) {
                s = "null";
            }
            this.write(StringUtils.getBytes((String)s, (String)HTTPServletResponseImpl.this.characterEncoding));
        }

        public void flush() throws IOException {
            this.bufferedHTTPOutputStream.flush();
        }

        public void close() throws IOException {
            this.bufferedHTTPOutputStream.close();
        }
    }
}

