/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet;

import com.firefly.codec.http2.encode.UrlEncoded;
import com.firefly.codec.http2.model.CookieParser;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.model.MultiPartInputStreamParser;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.server.exception.HttpServerException;
import com.firefly.server.http2.servlet.AsyncContextImpl;
import com.firefly.server.http2.servlet.HTTPServletResponseImpl;
import com.firefly.server.http2.servlet.HttpStringBodyRequest;
import com.firefly.server.http2.servlet.RequestDispatcherImpl;
import com.firefly.server.http2.servlet.ServerHTTP2Configuration;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.collection.MultiMap;
import com.firefly.utils.io.ByteArrayPipedStream;
import com.firefly.utils.io.FilePipedStream;
import com.firefly.utils.io.IO;
import com.firefly.utils.io.PipedStream;
import com.firefly.utils.json.Json;
import com.firefly.utils.json.JsonArray;
import com.firefly.utils.json.JsonObject;
import com.firefly.utils.lang.StringParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServletRequestImpl
implements HttpServletRequest,
HttpStringBodyRequest,
Closeable {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final HTTPConnection connection;
    private final MetaData.Request request;
    private final HTTPServletResponseImpl response;
    private static final Cookie[] EMPTY_COOKIE_ARR = new Cookie[0];
    private Cookie[] cookies;
    private MultiMap<String> parameterMap;
    private Map<String, String[]> _parameterMap;
    private List<Locale> localeList;
    private Collection<Part> parts;
    private MultipartConfigElement multipartConfigElement;
    final ServerHTTP2Configuration http2Configuration;
    private Charset encoding;
    private String characterEncoding;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private boolean requestedSessionIdFromCookie;
    private boolean requestedSessionIdFromURL;
    private String requestedSessionId;
    private HttpSession httpSession;
    private PipedStream bodyPipedStream;
    private ServletInputStream servletInputStream;
    private BufferedReader bufferedReader;
    private AsyncContextImpl asyncContext;
    private RequestDispatcherImpl requestDispatcher;
    private String stringBody;

    HTTPServletRequestImpl(ServerHTTP2Configuration http2Configuration, MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
        this.request = request;
        this.connection = connection;
        this.http2Configuration = http2Configuration;
        try {
            this.setCharacterEncoding(http2Configuration.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("set character encoding error", (Throwable)e);
        }
        this.response = new HTTPServletResponseImpl(response, output, this);
    }

    HTTPServletResponseImpl getResponse() {
        return this.response;
    }

    public void setAttribute(String name, Object o) {
        this.attributeMap.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new IteratorWrap<String>(this.attributeMap.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.encoding = Charset.forName(env);
        this.characterEncoding = env;
    }

    public boolean isSecure() {
        return this.http2Configuration.isSecureConnectionEnabled();
    }

    public String getServerName() {
        return this.connection.getLocalAddress().getHostName();
    }

    public int getServerPort() {
        return this.connection.getLocalAddress().getPort();
    }

    public String getRemoteAddr() {
        return this.connection.getRemoteAddress().getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.connection.getRemoteAddress().getHostName();
    }

    public int getRemotePort() {
        return this.connection.getRemoteAddress().getPort();
    }

    public String getLocalName() {
        return this.connection.getLocalAddress().getHostName();
    }

    public String getLocalAddr() {
        return this.connection.getLocalAddress().getAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.connection.getLocalAddress().getPort();
    }

    public long getDateHeader(String name) {
        return this.request.getFields().getDateField(name);
    }

    public String getHeader(String name) {
        return this.request.getFields().get(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.request.getFields().getValues(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getFields().getFieldNames();
    }

    public int getIntHeader(String name) {
        return (int)this.request.getFields().getLongField(name);
    }

    public int getContentLength() {
        return (int)this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getFields().get(HttpHeader.CONTENT_TYPE);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getRequestURI() {
        return this.request.getURI().getPath();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getProtocol() {
        return this.request.getHttpVersion().asString();
    }

    public String getScheme() {
        return this.request.getURI().getScheme();
    }

    public String getQueryString() {
        return this.request.getURI().getQuery();
    }

    public Locale getLocale() {
        this.parseLocales();
        return this.localeList.get(0);
    }

    public Enumeration<Locale> getLocales() {
        this.parseLocales();
        return new IteratorWrap<Locale>(this.localeList.iterator());
    }

    private void parseLocales() {
        if (this.localeList == null) {
            this.localeList = new ArrayList<Locale>();
            Enumeration<String> values = this.getHeaders("accept-language");
            while (values.hasMoreElements()) {
                this.parseLocalesHeader(values.nextElement());
            }
            if (this.localeList.size() == 0) {
                this.localeList.add(Locale.getDefault());
            }
        }
    }

    private void parseLocalesHeader(String value) {
        int start;
        StringParser parser = new StringParser();
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuilder sb = new StringBuilder();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        parser.setString(value);
        int length = parser.getLength();
        while ((start = parser.getIndex()) < length) {
            String variant;
            String country;
            String language;
            int end = parser.findChar(',');
            String entry = parser.extract(start, end).trim();
            parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    String strQuality = entry.substring(semi + 3);
                    quality = strQuality.length() <= 5 ? Double.parseDouble(strQuality) : 0.0;
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            if (!StringUtils.isAlpha((String)language) || !StringUtils.isAlpha((String)country) || !StringUtils.isAlpha((String)variant)) continue;
            Locale locale = new Locale(language, country, variant);
            Double key = -quality;
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        for (Double key : locales.keySet()) {
            ArrayList list = (ArrayList)locales.get(key);
            if (list == null || list.size() <= 0) continue;
            this.localeList.addAll(list);
        }
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            String cookieStr = this.getHeader("Cookie");
            if (VerifyUtils.isEmpty((String)cookieStr)) {
                this.cookies = EMPTY_COOKIE_ARR;
            } else {
                List<Cookie> list = CookieParser.parserServletCookie(cookieStr);
                this.cookies = list.toArray(EMPTY_COOKIE_ARR);
            }
            return this.cookies;
        }
        return this.cookies;
    }

    PipedStream getBodyPipedStream() {
        if (this.bodyPipedStream == null) {
            long contentLength = this.request.getContentLength();
            this.bodyPipedStream = contentLength > 0L ? (contentLength > (long)this.http2Configuration.getHttpBodyThreshold() ? new FilePipedStream(this.http2Configuration.getTemporaryDirectory()) : new ByteArrayPipedStream((int)contentLength)) : new FilePipedStream(this.http2Configuration.getTemporaryDirectory());
            return this.bodyPipedStream;
        }
        return this.bodyPipedStream;
    }

    private boolean hasData() {
        return this.bodyPipedStream != null;
    }

    void completeDataReceiving() {
        if (this.hasData()) {
            try {
                this.getBodyPipedStream().getOutputStream().close();
            }
            catch (IOException e) {
                log.error("close http body piped output stream exception", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        if (this.hasData()) {
            try {
                this.getBodyPipedStream().close();
            }
            catch (IOException e) {
                log.error("close http body piped stream exception", (Throwable)e);
            }
            if (this.parts != null) {
                for (Part part : this.parts) {
                    try {
                        part.delete();
                    }
                    catch (IOException e) {
                        log.error("delete temporary file exception", (Throwable)e);
                    }
                }
            }
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = new HTTPServletInputStream();
            return this.servletInputStream;
        }
        return this.servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.encoding));
            return this.bufferedReader;
        }
        return this.bufferedReader;
    }

    private MultiMap<String> getParameters() {
        if (this.parameterMap == null) {
            this.parameterMap = new MultiMap();
            try {
                this.request.getURI().decodeQueryTo(this.parameterMap, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                log.error("parse parameters exception", (Throwable)e);
            }
            String contentType = this.getContentType();
            if (this.hasData() && contentType != null && contentType.startsWith("application/x-www-form-urlencoded") && ("POST".equals(this.request.getMethod()) || "PUT".equals(this.request.getMethod()))) {
                try (BufferedReader in = this.getReader();){
                    String urlencodedForm = IO.toString((Reader)in);
                    UrlEncoded.decodeTo(urlencodedForm, this.parameterMap, this.encoding);
                }
                catch (IOException e) {
                    log.error("parse urlencoded form exception", (Throwable)e);
                }
            }
            return this.parameterMap;
        }
        return this.parameterMap;
    }

    public String getParameter(String name) {
        List values = (List)this.getParameters().get((Object)name);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        Set names = this.getParameters().keySet();
        if (names.size() > 0) {
            return new IteratorWrap<String>(names.iterator());
        }
        return Collections.emptyEnumeration();
    }

    public String[] getParameterValues(String name) {
        List values = this.getParameters().getValues(name);
        if (values != null) {
            return values.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        if (this._parameterMap == null) {
            this._parameterMap = this.getParameters().toStringArrayMap();
        }
        return this._parameterMap;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.parts == null) {
            try (ServletInputStream input = this.getInputStream();){
                MultiPartInputStreamParser parser = this.getMultiPartInputStreamParser(input);
                parser.setDeleteOnExit(true);
                this.parts = parser.getParts();
            }
            return this.parts;
        }
        return this.parts;
    }

    private MultiPartInputStreamParser getMultiPartInputStreamParser(ServletInputStream input) {
        if (this.multipartConfigElement != null) {
            return new MultiPartInputStreamParser((InputStream)input, this.getContentType(), this.multipartConfigElement, new File(this.http2Configuration.getTemporaryDirectory()));
        }
        if (this.http2Configuration.getMultipartConfigElement() != null) {
            return new MultiPartInputStreamParser((InputStream)input, this.getContentType(), this.http2Configuration.getMultipartConfigElement(), new File(this.http2Configuration.getTemporaryDirectory()));
        }
        return new MultiPartInputStreamParser((InputStream)input, this.getContentType(), this.http2Configuration.getDefaultMultipartConfigElement(), new File(this.http2Configuration.getTemporaryDirectory()));
    }

    public Part getPart(String name) throws IOException, ServletException {
        for (Part part : this.getParts()) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        return null;
    }

    public static String getSessionId(String uri, String sessionIdName) {
        String sessionId = null;
        int i = uri.indexOf(59);
        int j = uri.indexOf(35);
        if (i > 0) {
            String tmp = j > i ? uri.substring(i + 1, j) : uri.substring(i + 1);
            int m = 0;
            for (int k = 0; k < tmp.length(); ++k) {
                if (tmp.charAt(k) != '=') continue;
                m = k;
                break;
            }
            if (m > 0) {
                String name = tmp.substring(0, m);
                String value = tmp.substring(m + 1);
                if (name.equals(sessionIdName)) {
                    sessionId = value;
                }
            }
        }
        return sessionId;
    }

    public String getRequestedSessionId() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionId;
        }
        if (this.isRequestedSessionIdFromCookie()) {
            return this.requestedSessionId;
        }
        if (this.isRequestedSessionIdFromURL()) {
            return this.requestedSessionId;
        }
        return null;
    }

    private HttpSession _getSession() {
        if (this.httpSession == null) {
            String sid = this.getRequestedSessionId();
            this.httpSession = sid != null ? this.http2Configuration.getHttpSessionManager().get(sid) : null;
            return this.httpSession;
        }
        return this.httpSession;
    }

    public HttpSession getSession(boolean create) {
        if (create) {
            this.httpSession = this.http2Configuration.getHttpSessionManager().create();
            this.requestedSessionId = this.httpSession.getId();
            this.response.addCookie(new Cookie(this.http2Configuration.getSessionIdName(), this.httpSession.getId()));
            return this.httpSession;
        }
        return this._getSession();
    }

    public HttpSession getSession() {
        this.httpSession = this._getSession();
        if (this.httpSession == null) {
            return this.getSession(true);
        }
        return this.httpSession;
    }

    public String changeSessionId() {
        this.getSession(true);
        return this.requestedSessionId;
    }

    public boolean isRequestedSessionIdValid() {
        String sid = this.getRequestedSessionId();
        return sid != null && this.http2Configuration.getHttpSessionManager().containsKey(sid);
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionIdFromCookie;
        }
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getName().equals(this.http2Configuration.getSessionIdName())) continue;
            this.requestedSessionId = cookie.getValue();
            this.requestedSessionIdFromCookie = true;
            this.requestedSessionIdFromURL = false;
            return true;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionIdFromURL;
        }
        String sessionId = HTTPServletRequestImpl.getSessionId(this.getRequestURI(), this.http2Configuration.getSessionIdName());
        if (VerifyUtils.isNotEmpty((String)sessionId)) {
            this.requestedSessionId = sessionId;
            this.requestedSessionIdFromURL = true;
            this.requestedSessionIdFromCookie = false;
            return true;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.startAsync((ServletRequest)this, (ServletResponse)this.response);
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (this.asyncContext == null) {
            this.asyncContext = new AsyncContextImpl();
        }
        this.asyncContext.startAsync(servletRequest, servletResponse, servletRequest == this && servletResponse == this.response, this.http2Configuration.getAsynchronousContextTimeout());
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncContext != null && this.asyncContext.isStartAsync();
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw new IllegalStateException("asynchronous servlet doesn't start!");
        }
        return this.asyncContext;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.requestDispatcher == null) {
            this.requestDispatcher = new RequestDispatcherImpl();
        }
        this.requestDispatcher.path = path;
        return this.requestDispatcher;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public String getContextPath() {
        return "";
    }

    public String getServletPath() {
        return "";
    }

    public String getRealPath(String path) {
        throw new HttpServerException("not implement this method!");
    }

    public ServletContext getServletContext() {
        throw new HttpServerException("not implement this method!");
    }

    public String getAuthType() {
        throw new HttpServerException("not implement this method!");
    }

    public String getPathInfo() {
        throw new HttpServerException("not implement this method!");
    }

    public String getPathTranslated() {
        throw new HttpServerException("not implement this method!");
    }

    public String getRemoteUser() {
        throw new HttpServerException("not implement this method!");
    }

    public boolean isUserInRole(String role) {
        throw new HttpServerException("not implement this method!");
    }

    public Principal getUserPrincipal() {
        throw new HttpServerException("not implement this method!");
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new HttpServerException("not implement this method!");
    }

    public void login(String username, String password) throws ServletException {
        throw new HttpServerException("not implement this method!");
    }

    public void logout() throws ServletException {
        throw new HttpServerException("not implement this method!");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new HttpServerException("not implement this method!");
    }

    @Override
    public String getStringBody() {
        return this.getStringBody(this.getCharacterEncoding());
    }

    @Override
    public String getStringBody(String charset) {
        if (this.stringBody != null) {
            return this.stringBody;
        }
        try (ServletInputStream in = this.getInputStream();){
            this.stringBody = IO.toString((InputStream)in, (String)charset);
        }
        catch (IOException e) {
            log.error("get http request string body exception", (Throwable)e);
        }
        if (this.stringBody == null) {
            this.stringBody = "";
        }
        return this.stringBody;
    }

    @Override
    public <T> T getJsonBody(Class<T> clazz) {
        return (T)Json.toObject((String)this.getStringBody(), clazz);
    }

    @Override
    public JsonObject getJsonObjectBody() {
        return Json.toJsonObject((String)this.getStringBody());
    }

    @Override
    public JsonArray getJsonArrayBody() {
        return Json.toJsonArray((String)this.getStringBody());
    }

    public void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }

    private class HTTPServletInputStream
    extends ServletInputStream {
        private volatile boolean finished;

        private HTTPServletInputStream() {
        }

        public int available() throws IOException {
            if (HTTPServletRequestImpl.this.hasData()) {
                return HTTPServletRequestImpl.this.getBodyPipedStream().getInputStream().available();
            }
            return 0;
        }

        public void close() throws IOException {
            if (HTTPServletRequestImpl.this.hasData()) {
                HTTPServletRequestImpl.this.getBodyPipedStream().getInputStream().close();
            }
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return HTTPServletRequestImpl.this.hasData();
        }

        public void setReadListener(ReadListener readListener) {
            if (HTTPServletRequestImpl.this.hasData()) {
                try {
                    readListener.onDataAvailable();
                    readListener.onAllDataRead();
                }
                catch (IOException e) {
                    readListener.onError((Throwable)e);
                }
            }
        }

        public int read() throws IOException {
            this.finished = true;
            if (HTTPServletRequestImpl.this.hasData()) {
                return HTTPServletRequestImpl.this.getBodyPipedStream().getInputStream().read();
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.finished = true;
            if (HTTPServletRequestImpl.this.hasData()) {
                return HTTPServletRequestImpl.this.getBodyPipedStream().getInputStream().read(b, off, len);
            }
            return -1;
        }
    }

    private static class IteratorWrap<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        IteratorWrap(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }
}

