/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2.servlet;

import com.firefly.server.http2.servlet.AsyncListenerWrapper;
import com.firefly.server.http2.servlet.ServerHTTP2Configuration;
import com.firefly.utils.time.HashTimeWheel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncContextImpl
implements AsyncContext {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private static final HashTimeWheel TIME_WHEEL = new HashTimeWheel();
    private static ExecutorService executor;
    private long timeout = -1L;
    private boolean originalRequestAndResponse = true;
    private volatile boolean startAsync = false;
    private volatile boolean complete = false;
    private ServletRequest request;
    private ServletResponse response;
    private final List<AsyncListenerWrapper> listeners = new ArrayList<AsyncListenerWrapper>();
    private final TransferQueue<Future<?>> threadFutureList = new LinkedTransferQueue();
    private volatile HashTimeWheel.Future timeoutFuture;

    public static void init(ServerHTTP2Configuration config) {
        executor = new ThreadPoolExecutor(config.getAsynchronousContextCorePoolSize(), config.getAsynchronousContextMaximumPoolSize(), (long)config.getAsynchronousContextCorePoolKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), new AsyncContextTreadFactory());
    }

    public static void shutdown() {
        executor.shutdown();
        TIME_WHEEL.stop();
    }

    public boolean isStartAsync() {
        return this.startAsync;
    }

    public void startAsync(ServletRequest request, ServletResponse response, boolean originalRequestAndResponse, long t) {
        this.request = request;
        this.response = response;
        this.originalRequestAndResponse = originalRequestAndResponse;
        this.setTimeout(t);
        this.fireOnStartAsync();
        this.startAsync = true;
        this.complete = false;
    }

    public void complete() {
        if (this.complete) {
            return;
        }
        this.timeoutFuture.cancel();
        this.fireOnComplete();
        this.startAsync = false;
        this.complete = true;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.originalRequestAndResponse;
    }

    public void dispatch() {
        HttpServletRequest sr = (HttpServletRequest)this.getRequest();
        String path = sr.getRequestURI();
        this.dispatch(path);
    }

    public void dispatch(String path) {
        this.dispatch(null, path);
    }

    public void dispatch(ServletContext context, String path) {
        this.complete();
        try {
            this.request.getRequestDispatcher(path).forward(this.request, this.response);
        }
        catch (Throwable e) {
            log.error("async dispatch exception", e);
            this.fireOnError();
        }
    }

    public void start(Runnable runnable) {
        Future<?> future = executor.submit(runnable);
        this.threadFutureList.offer(future);
    }

    public void addListener(AsyncListener listener) {
        this.addListener(listener, this.request, this.response);
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        AsyncListenerWrapper wrapper = new AsyncListenerWrapper(this, listener, servletRequest, servletResponse);
        this.listeners.add(wrapper);
    }

    private void fireOnStartAsync() {
        List<AsyncListenerWrapper> listenersCopy = this.getListenersCopy();
        for (AsyncListenerWrapper listener : listenersCopy) {
            try {
                listener.fireOnStartAsync();
            }
            catch (IOException e) {
                log.error("async start event error", (Throwable)e);
                this.fireOnError();
            }
        }
    }

    private void fireOnComplete() {
        List<AsyncListenerWrapper> listenersCopy = this.getListenersCopy();
        for (AsyncListenerWrapper listener : listenersCopy) {
            try {
                listener.fireOnComplete();
            }
            catch (IOException e) {
                log.error("async complete event error", (Throwable)e);
                this.fireOnError();
            }
        }
    }

    private void fireOnTimeout() {
        List<AsyncListenerWrapper> listenersCopy = this.getListenersCopy();
        for (AsyncListenerWrapper listener : listenersCopy) {
            try {
                listener.fireOnTimeout();
            }
            catch (IOException e) {
                log.error("async timeout event error", (Throwable)e);
                this.fireOnError();
            }
        }
    }

    private void fireOnError() {
        List<AsyncListenerWrapper> listenersCopy = this.getListenersCopy();
        for (AsyncListenerWrapper listener : listenersCopy) {
            try {
                listener.fireOnError();
            }
            catch (IOException e) {
                log.error("async error event exception", (Throwable)e);
            }
        }
    }

    private List<AsyncListenerWrapper> getListenersCopy() {
        ArrayList<AsyncListenerWrapper> listenersCopy = new ArrayList<AsyncListenerWrapper>(this.listeners);
        return listenersCopy;
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        try {
            listener = (AsyncListener)clazz.newInstance();
        }
        catch (Throwable e) {
            log.error("create async listener error", e);
        }
        return (T)listener;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        if (timeout <= 0L) {
            return;
        }
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel();
        }
        this.timeoutFuture = TIME_WHEEL.add(timeout, new Runnable(){

            @Override
            public void run() {
                if (AsyncContextImpl.this.complete) {
                    return;
                }
                Future f = null;
                while ((f = (Future)AsyncContextImpl.this.threadFutureList.poll()) != null) {
                    if (f.isDone() || f.isCancelled()) continue;
                    f.cancel(true);
                }
                AsyncContextImpl.this.fireOnTimeout();
                AsyncContextImpl.this.startAsync = false;
                AsyncContextImpl.this.complete = false;
            }
        });
    }

    public long getTimeout() {
        return this.timeout;
    }

    static {
        TIME_WHEEL.start();
    }

    public static class AsyncContextTreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "firefly asynchronous context thread");
        }
    }
}

