/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.model.Cookie;
import com.firefly.codec.http2.model.CookieGenerator;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpFields;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.BufferedHTTPOutputStream;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleResponse
implements Closeable {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    MetaData.Response response;
    HTTPOutputStream output;
    PrintWriter printWriter;
    BufferedHTTPOutputStream bufferedOutputStream;
    int bufferSize = 8192;
    String characterEncoding = "UTF-8";
    boolean asynchronous;

    public SimpleResponse(MetaData.Response response, HTTPOutputStream output) {
        this.output = output;
        this.response = response;
    }

    public HttpVersion getHttpVersion() {
        return this.response.getHttpVersion();
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        this.response.setHttpVersion(httpVersion);
    }

    public HttpFields getFields() {
        return this.response.getFields();
    }

    public long getContentLength() {
        return this.response.getContentLength();
    }

    public Iterator<HttpField> iterator() {
        return this.response.iterator();
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getReason() {
        return this.response.getReason();
    }

    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    public void setReason(String reason) {
        this.response.setReason(reason);
    }

    public void forEach(Consumer<? super HttpField> action) {
        this.response.forEach(action);
    }

    public Spliterator<HttpField> spliterator() {
        return this.response.spliterator();
    }

    public MetaData.Response getResponse() {
        return this.response;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public void addCookie(Cookie cookie) {
        this.response.getFields().add(HttpHeader.SET_COOKIE, CookieGenerator.generateSetCookie(cookie));
    }

    public synchronized OutputStream getOutputStream() {
        if (this.printWriter != null) {
            throw new IllegalStateException("the response has used print writer");
        }
        if (this.bufferedOutputStream == null) {
            this.bufferedOutputStream = new BufferedHTTPOutputStream(this.output, this.bufferSize);
            return this.bufferedOutputStream;
        }
        return this.bufferedOutputStream;
    }

    public synchronized PrintWriter getPrintWriter() {
        if (this.bufferedOutputStream != null) {
            throw new IllegalStateException("the response has used output stream");
        }
        if (this.printWriter == null) {
            try {
                this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedHTTPOutputStream(this.output, this.bufferSize), this.characterEncoding));
            }
            catch (UnsupportedEncodingException e) {
                log.error("create print writer exception", (Throwable)e);
            }
            return this.printWriter;
        }
        return this.printWriter;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isClosed() {
        return this.output.isClosed();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.bufferedOutputStream != null) {
            this.bufferedOutputStream.close();
        } else if (this.printWriter != null) {
            this.printWriter.close();
        } else {
            this.getOutputStream().close();
        }
    }

    public synchronized void flush() throws IOException {
        if (this.bufferedOutputStream != null) {
            this.bufferedOutputStream.flush();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }
}

