/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.model.Cookie;
import com.firefly.codec.http2.model.CookieParser;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpFields;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpURI;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.server.http2.SimpleResponse;
import com.firefly.utils.function.Action1;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.json.Json;
import com.firefly.utils.json.JsonArray;
import com.firefly.utils.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class SimpleRequest {
    MetaData.Request request;
    SimpleResponse response;
    HTTPConnection connection;
    Action1<ByteBuffer> content;
    Action1<SimpleRequest> contentComplete;
    Action1<SimpleRequest> messageComplete;
    List<ByteBuffer> requestBody = new ArrayList<ByteBuffer>();
    List<Cookie> cookies;
    String stringBody;
    ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();

    public SimpleRequest(MetaData.Request request, MetaData.Response response, HTTPOutputStream output) {
        this.request = request;
        response.setStatus(200);
        response.setHttpVersion(HttpVersion.HTTP_1_1);
        this.response = new SimpleResponse(response, output);
    }

    public HttpVersion getHttpVersion() {
        return this.request.getHttpVersion();
    }

    public HttpFields getFields() {
        return this.request.getFields();
    }

    public long getContentLength() {
        return this.getFields().getLongField(HttpHeader.CONTENT_LENGTH.asString());
    }

    public Iterator<HttpField> iterator() {
        return this.request.iterator();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public HttpURI getURI() {
        return this.request.getURI();
    }

    public String getURIString() {
        return this.request.getURIString();
    }

    public void forEach(Consumer<? super HttpField> action) {
        this.request.forEach(action);
    }

    public Spliterator<HttpField> spliterator() {
        return this.request.spliterator();
    }

    public Object get(String key) {
        return this.attributes.get(key);
    }

    public Object put(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public Object remove(String key) {
        return this.attributes.remove(key);
    }

    public ConcurrentHashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.request.toString();
    }

    public MetaData.Request getRequest() {
        return this.request;
    }

    public SimpleResponse getResponse() {
        return this.response;
    }

    public SimpleResponse getAsyncResponse() {
        this.response.setAsynchronous(true);
        return this.response;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public List<ByteBuffer> getRequestBody() {
        return this.requestBody;
    }

    public SimpleRequest content(Action1<ByteBuffer> content) {
        this.content = content;
        return this;
    }

    public SimpleRequest contentComplete(Action1<SimpleRequest> contentComplete) {
        this.contentComplete = contentComplete;
        return this;
    }

    public SimpleRequest messageComplete(Action1<SimpleRequest> messageComplete) {
        this.messageComplete = messageComplete;
        return this;
    }

    public String getStringBody(String charset) {
        if (this.stringBody == null) {
            this.stringBody = BufferUtils.toString(this.requestBody, (String)charset);
            return this.stringBody;
        }
        return this.stringBody;
    }

    public String getStringBody() {
        return this.getStringBody("UTF-8");
    }

    public <T> T getJsonBody(Class<T> clazz) {
        return (T)Json.toObject((String)this.getStringBody(), clazz);
    }

    public JsonObject getJsonObjectBody() {
        return Json.toJsonObject((String)this.getStringBody());
    }

    public JsonArray getJsonArrayBody() {
        return Json.toJsonArray((String)this.getStringBody());
    }

    public List<Cookie> getCookies() {
        if (this.cookies == null) {
            String v = this.request.getFields().get(HttpHeader.COOKIE);
            this.cookies = CookieParser.parseCookie(v);
            return this.cookies;
        }
        return this.cookies;
    }
}

