/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.server.http2.HTTP2Server;
import com.firefly.server.http2.HTTPServerConnection;
import com.firefly.server.http2.ServerHTTPHandler;
import com.firefly.server.http2.SimpleHTTPServerConfiguration;
import com.firefly.server.http2.SimpleRequest;
import com.firefly.utils.function.Action1;
import com.firefly.utils.function.Action2;
import com.firefly.utils.function.Action3;
import com.firefly.utils.function.Action4;
import com.firefly.utils.function.Action6;
import com.firefly.utils.function.Func4;
import com.firefly.utils.function.Func5;
import com.firefly.utils.io.IO;
import com.firefly.utils.lang.AbstractLifeCycle;
import java.io.Closeable;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHTTPServer
extends AbstractLifeCycle {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private HTTP2Server http2Server;
    private SimpleHTTPServerConfiguration configuration;
    private Action1<SimpleRequest> headerComplete;
    private Action3<Integer, String, SimpleRequest> badMessage;
    private Action1<SimpleRequest> earlyEof;
    private Action1<HTTPConnection> acceptConnection;
    Action2<SimpleRequest, HTTPServerConnection> tunnel;

    public SimpleHTTPServer() {
        this(new SimpleHTTPServerConfiguration());
    }

    public SimpleHTTPServer(SimpleHTTPServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public SimpleHTTPServer acceptHTTPTunnelConnection(Action2<SimpleRequest, HTTPServerConnection> tunnel) {
        this.tunnel = tunnel;
        return this;
    }

    public SimpleHTTPServer headerComplete(Action1<SimpleRequest> headerComplete) {
        this.headerComplete = headerComplete;
        return this;
    }

    public SimpleHTTPServer earlyEof(Action1<SimpleRequest> earlyEof) {
        this.earlyEof = earlyEof;
        return this;
    }

    public SimpleHTTPServer badMessage(Action3<Integer, String, SimpleRequest> badMessage) {
        this.badMessage = badMessage;
        return this;
    }

    public SimpleHTTPServer acceptConnection(Action1<HTTPConnection> acceptConnection) {
        this.acceptConnection = acceptConnection;
        return this;
    }

    public void listen(String host, int port) {
        this.configuration.setHost(host);
        this.configuration.setPort(port);
        this.listen();
    }

    public void listen() {
        this.start();
    }

    protected void init() {
        this.http2Server = new HTTP2Server(this.configuration.getHost(), this.configuration.getPort(), this.configuration, new ServerHTTPHandler.Adapter().acceptHTTPTunnelConnection((Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPServerConnection, Boolean>)((Func4)(request, response, out, connection) -> {
            SimpleRequest r = new SimpleRequest((MetaData.Request)request, (MetaData.Response)response, (HTTPOutputStream)out);
            request.setAttachment(r);
            if (this.tunnel != null) {
                this.tunnel.call((Object)r, connection);
            }
            return true;
        })).headerComplete((Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func4)(request, response, out, connection) -> {
            SimpleRequest r = new SimpleRequest((MetaData.Request)request, (MetaData.Response)response, (HTTPOutputStream)out);
            request.setAttachment(r);
            if (this.headerComplete != null) {
                this.headerComplete.call((Object)r);
            }
            return false;
        })).content((Func5<ByteBuffer, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func5)(buffer, request, response, out, connection) -> {
            SimpleRequest r = (SimpleRequest)request.getAttachment();
            if (r.content != null) {
                r.content.call(buffer);
            } else {
                r.requestBody.add((ByteBuffer)buffer);
            }
            return false;
        })).contentComplete((Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func4)(request, response, out, connection) -> {
            SimpleRequest r = (SimpleRequest)request.getAttachment();
            if (r.contentComplete != null) {
                r.contentComplete.call((Object)r);
            }
            return false;
        })).messageComplete((Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func4)(request, response, out, connection) -> {
            SimpleRequest r = (SimpleRequest)request.getAttachment();
            if (r.messageComplete != null) {
                r.messageComplete.call((Object)r);
            }
            if (!r.getResponse().isAsynchronous()) {
                IO.close((Closeable)r.getResponse());
            }
            return true;
        })).badMessage((Action6<Integer, String, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection>)((Action6)(status, reason, request, response, out, connection) -> {
            if (this.badMessage != null) {
                if (request.getAttachment() != null) {
                    SimpleRequest r = (SimpleRequest)request.getAttachment();
                    this.badMessage.call(status, reason, (Object)r);
                } else {
                    SimpleRequest r = new SimpleRequest((MetaData.Request)request, (MetaData.Response)response, (HTTPOutputStream)out);
                    request.setAttachment(r);
                    this.badMessage.call(status, reason, (Object)r);
                }
            }
        })).earlyEOF((Action4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection>)((Action4)(request, response, out, connection) -> {
            if (this.earlyEof != null) {
                if (request.getAttachment() != null) {
                    SimpleRequest r = (SimpleRequest)request.getAttachment();
                    this.earlyEof.call((Object)r);
                } else {
                    SimpleRequest r = new SimpleRequest((MetaData.Request)request, (MetaData.Response)response, (HTTPOutputStream)out);
                    request.setAttachment(r);
                    this.earlyEof.call((Object)r);
                }
            }
        })));
        this.http2Server.start();
    }

    protected void destroy() {
        this.http2Server.stop();
    }
}

