/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.net.DecoderChain;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.server.http2.HTTP1ServerConnection;
import com.firefly.server.http2.HTTP2ServerConnection;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSecureDecoder
extends DecoderChain {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public ServerSecureDecoder(DecoderChain next) {
        super(next);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(ByteBuffer buf, Session session) throws Throwable {
        if (session.getAttachment() instanceof HTTPConnection) {
            ByteBuffer plaintext;
            HTTPConnection connection = (HTTPConnection)session.getAttachment();
            switch (connection.getHttpVersion()) {
                case HTTP_2: {
                    plaintext = ((HTTP2ServerConnection)connection).getSSLSession().read(buf);
                    break;
                }
                case HTTP_1_1: {
                    plaintext = ((HTTP1ServerConnection)connection).getSSLSession().read(buf);
                    break;
                }
                default: {
                    throw new IllegalStateException("server does not support the http version " + (Object)((Object)connection.getHttpVersion()));
                }
            }
            if (plaintext == null || this.next == null) return;
            this.next.decode(plaintext, session);
            return;
        } else {
            if (!(session.getAttachment() instanceof SSLSession)) return;
            SSLSession sslSession = (SSLSession)session.getAttachment();
            ByteBuffer plaintext = sslSession.read(buf);
            if (plaintext != null && plaintext.hasRemaining()) {
                log.debug("server session {} handshake finished and received cleartext size {}", (Object)session.getSessionId(), (Object)plaintext.remaining());
                if (!(session.getAttachment() instanceof HTTPConnection)) throw new IllegalStateException("the server http connection has not been created");
                if (this.next == null) return;
                this.next.decode(plaintext, session);
                return;
            } else {
                log.debug("server ssl session {} is shaking hands", (Object)session.getSessionId());
            }
        }
    }
}

