/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.codec.http2.stream.HTTPHandler;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.server.http2.HTTPServerConnection;
import com.firefly.utils.function.Action1;
import com.firefly.utils.function.Action4;
import com.firefly.utils.function.Action6;
import com.firefly.utils.function.Func4;
import com.firefly.utils.function.Func5;
import java.nio.ByteBuffer;

public interface ServerHTTPHandler
extends HTTPHandler {
    public void acceptConnection(HTTPConnection var1);

    public boolean accept100Continue(MetaData.Request var1, MetaData.Response var2, HTTPOutputStream var3, HTTPConnection var4);

    public boolean acceptHTTPTunnelConnection(MetaData.Request var1, MetaData.Response var2, HTTPOutputStream var3, HTTPServerConnection var4);

    public static class Adapter
    extends HTTPHandler.Adapter
    implements ServerHTTPHandler {
        protected Action1<HTTPConnection> acceptConnection;
        protected Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> accept100Continue;
        protected Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPServerConnection, Boolean> acceptHTTPTunnelConnection;

        public Adapter headerComplete(Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> headerComplete) {
            this.headerComplete = headerComplete;
            return this;
        }

        public Adapter messageComplete(Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> messageComplete) {
            this.messageComplete = messageComplete;
            return this;
        }

        public Adapter content(Func5<ByteBuffer, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> content) {
            this.content = content;
            return this;
        }

        public Adapter contentComplete(Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> contentComplete) {
            this.contentComplete = contentComplete;
            return this;
        }

        public Adapter badMessage(Action6<Integer, String, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection> badMessage) {
            this.badMessage = badMessage;
            return this;
        }

        public Adapter earlyEOF(Action4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection> earlyEOF) {
            this.earlyEOF = earlyEOF;
            return this;
        }

        public Adapter acceptConnection(Action1<HTTPConnection> acceptConnection) {
            this.acceptConnection = acceptConnection;
            return this;
        }

        public Adapter accept100Continue(Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> accept100Continue) {
            this.accept100Continue = accept100Continue;
            return this;
        }

        public Adapter acceptHTTPTunnelConnection(Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPServerConnection, Boolean> acceptHTTPTunnelConnection) {
            this.acceptHTTPTunnelConnection = acceptHTTPTunnelConnection;
            return this;
        }

        @Override
        public void acceptConnection(HTTPConnection connection) {
            if (this.acceptConnection != null) {
                this.acceptConnection.call((Object)connection);
            }
        }

        @Override
        public boolean accept100Continue(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
            if (this.accept100Continue != null) {
                return (Boolean)this.accept100Continue.call((Object)request, (Object)response, (Object)output, (Object)connection);
            }
            return false;
        }

        @Override
        public boolean acceptHTTPTunnelConnection(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPServerConnection connection) {
            if (this.acceptHTTPTunnelConnection != null) {
                return (Boolean)this.acceptHTTPTunnelConnection.call((Object)request, (Object)response, (Object)output, (Object)connection);
            }
            return true;
        }
    }
}

