/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.decode.ServerParser;
import com.firefly.codec.http2.encode.Generator;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PushPromiseFrame;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.FlowControlStrategy;
import com.firefly.codec.http2.stream.HTTP2Session;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.codec.http2.stream.StreamSPI;
import com.firefly.net.Session;
import com.firefly.server.http2.ServerSessionListener;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.Scheduler;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ServerSession
extends HTTP2Session
implements ServerParser.Listener {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final ServerSessionListener listener;

    public HTTP2ServerSession(Scheduler scheduler, Session endPoint, Generator generator, ServerSessionListener listener, FlowControlStrategy flowControl, int streamIdleTimeout) {
        super(scheduler, endPoint, generator, listener, flowControl, 2, streamIdleTimeout);
        this.listener = listener;
    }

    @Override
    public void onPreface() {
        Map<Integer, Integer> settings = this.notifyPreface(this);
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        SettingsFrame settingsFrame = new SettingsFrame(settings, false);
        WindowUpdateFrame windowFrame = null;
        int sessionWindow = this.getInitialSessionRecvWindow() - 65535;
        if (sessionWindow > 0) {
            this.updateRecvWindow(sessionWindow);
            windowFrame = new WindowUpdateFrame(0, sessionWindow);
        }
        if (windowFrame == null) {
            this.frames(null, Callback.NOOP, settingsFrame, Frame.EMPTY_ARRAY);
        } else {
            this.frames(null, Callback.NOOP, settingsFrame, windowFrame);
        }
    }

    @Override
    public void onHeaders(HeadersFrame frame) {
        MetaData metaData;
        if (log.isDebugEnabled()) {
            log.debug("Received {}", (Object)frame);
        }
        if ((metaData = frame.getMetaData()).isRequest()) {
            StreamSPI stream = this.createRemoteStream(frame.getStreamId());
            if (stream != null) {
                stream.process(frame, Callback.NOOP);
                Stream.Listener listener = this.notifyNewStream(stream, frame);
                stream.setListener(listener);
            }
        } else {
            this.onConnectionFailure(ErrorCode.INTERNAL_ERROR.code, "invalid_request");
        }
    }

    @Override
    public void onPushPromise(PushPromiseFrame frame) {
        this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "push_promise");
    }

    private Map<Integer, Integer> notifyPreface(com.firefly.codec.http2.stream.Session session) {
        try {
            return this.listener.onPreface(session);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
            return null;
        }
    }

    @Override
    public void onFrame(Frame frame) {
        switch (frame.getType()) {
            case PREFACE: {
                this.onPreface();
                break;
            }
            case SETTINGS: {
                this.onSettings((SettingsFrame)frame, false);
                break;
            }
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame);
                break;
            }
            default: {
                super.onFrame(frame);
            }
        }
    }
}

