/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.ResetFrame;
import com.firefly.codec.http2.model.HttpFields;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.AbstractHTTP2OutputStream;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.server.http2.HTTP2ServerConnection;
import com.firefly.server.http2.HTTPServerResponse;
import com.firefly.server.http2.ServerHTTPHandler;
import com.firefly.server.http2.ServerSessionListener;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.concurrent.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ServerRequestHandler
extends ServerSessionListener.Adapter {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final ServerHTTPHandler serverHTTPHandler;
    HTTP2ServerConnection connection;

    public HTTP2ServerRequestHandler(ServerHTTPHandler serverHTTPHandler) {
        this.serverHTTPHandler = serverHTTPHandler;
    }

    @Override
    public Stream.Listener onNewStream(final Stream stream, HeadersFrame headersFrame) {
        if (!headersFrame.getMetaData().isRequest()) {
            throw new IllegalArgumentException("the stream " + stream.getId() + " received meta data that is not request type");
        }
        if (log.isDebugEnabled()) {
            log.debug("the remote stream {} is created, the header is {}", (Object)stream.getId(), (Object)headersFrame.getMetaData());
        }
        final MetaData.Request request = (MetaData.Request)headersFrame.getMetaData();
        final HTTPServerResponse response = new HTTPServerResponse();
        final AbstractHTTP2OutputStream output = new AbstractHTTP2OutputStream(response, false){

            @Override
            protected Stream getStream() {
                return stream;
            }
        };
        String expectedValue = request.getFields().get(HttpHeader.EXPECT);
        if ("100-continue".equalsIgnoreCase(expectedValue)) {
            boolean skipNext = this.serverHTTPHandler.accept100Continue(request, response, output, this.connection);
            if (!skipNext) {
                MetaData.Response continue100 = new MetaData.Response(HttpVersion.HTTP_1_1, 100, "Continue", new HttpFields(), Long.MIN_VALUE);
                output.writeFrame(new HeadersFrame(stream.getId(), continue100, null, false));
                this.serverHTTPHandler.headerComplete(request, response, output, this.connection);
            }
        } else {
            this.serverHTTPHandler.headerComplete(request, response, output, this.connection);
            if (headersFrame.isEndStream()) {
                this.serverHTTPHandler.messageComplete(request, response, output, this.connection);
            }
        }
        return new Stream.Listener.Adapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onHeaders(Stream stream, HeadersFrame endHeaderframe) {
                if (log.isDebugEnabled()) {
                    log.debug("the stream {} received the end frame {}", (Object)stream.getId(), (Object)endHeaderframe);
                }
                if (!endHeaderframe.isEndStream()) throw new IllegalArgumentException("the stream " + stream.getId() + " received illegal meta data");
                String trailerName = request.getFields().get(HttpHeader.TRAILER);
                if (!VerifyUtils.isNotEmpty((String)trailerName)) throw new IllegalArgumentException("the stream " + stream.getId() + " received illegal meta data");
                if (!endHeaderframe.getMetaData().getFields().containsKey(trailerName)) {
                    throw new IllegalArgumentException("the stream " + stream.getId() + " received illegal meta data");
                }
                request.getFields().add(trailerName, endHeaderframe.getMetaData().getFields().get(trailerName));
                HTTP2ServerRequestHandler.this.serverHTTPHandler.messageComplete(request, response, output, HTTP2ServerRequestHandler.this.connection);
            }

            @Override
            public void onData(Stream stream, DataFrame dataFrame, Callback callback) {
                try {
                    HTTP2ServerRequestHandler.this.serverHTTPHandler.content(dataFrame.getData(), request, response, output, HTTP2ServerRequestHandler.this.connection);
                    callback.succeeded();
                }
                catch (Throwable t) {
                    callback.failed(t);
                }
                if (dataFrame.isEndStream()) {
                    HTTP2ServerRequestHandler.this.serverHTTPHandler.contentComplete(request, response, output, HTTP2ServerRequestHandler.this.connection);
                    HTTP2ServerRequestHandler.this.serverHTTPHandler.messageComplete(request, response, output, HTTP2ServerRequestHandler.this.connection);
                }
            }

            @Override
            public void onReset(Stream stream, ResetFrame resetFrame) {
                ErrorCode errorCode = ErrorCode.from(resetFrame.getError());
                String reason = errorCode == null ? "error=" + resetFrame.getError() : errorCode.name().toLowerCase();
                int status = 500;
                if (errorCode != null) {
                    switch (errorCode) {
                        case PROTOCOL_ERROR: {
                            status = 400;
                            break;
                        }
                        default: {
                            status = 500;
                        }
                    }
                }
                HTTP2ServerRequestHandler.this.serverHTTPHandler.badMessage(status, reason, request, response, output, HTTP2ServerRequestHandler.this.connection);
            }
        };
    }
}

