/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.stream.AbstractHTTPConnection;
import com.firefly.codec.http2.stream.AbstractHTTPHandler;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.server.http2.HTTP1ServerConnection;
import com.firefly.server.http2.HTTP1ServerRequestHandler;
import com.firefly.server.http2.HTTP2ServerConnection;
import com.firefly.server.http2.ServerHTTPHandler;
import com.firefly.server.http2.ServerSessionListener;

public class HTTP2ServerHandler
extends AbstractHTTPHandler {
    private final ServerSessionListener listener;
    private final ServerHTTPHandler serverHTTPHandler;

    public HTTP2ServerHandler(HTTP2Configuration config, ServerSessionListener listener, ServerHTTPHandler serverHTTPHandler) {
        super(config);
        this.listener = listener;
        this.serverHTTPHandler = serverHTTPHandler;
    }

    public void sessionOpened(Session session) throws Throwable {
        if (this.config.isSecureConnectionEnabled()) {
            session.attachObject((Object)new SSLSession(this.config.getSslContextFactory(), false, session, sslSession -> {
                log.debug("server session {} SSL handshake finished", (Object)session.getSessionId());
                AbstractHTTPConnection httpConnection = "http/1.1".equals(sslSession.applicationProtocol()) ? new HTTP1ServerConnection(this.config, session, sslSession, new HTTP1ServerRequestHandler(this.serverHTTPHandler), this.listener) : new HTTP2ServerConnection(this.config, session, sslSession, this.listener);
                session.attachObject((Object)httpConnection);
                this.serverHTTPHandler.acceptConnection(httpConnection);
            }));
        } else {
            HTTP1ServerConnection httpConnection = new HTTP1ServerConnection(this.config, session, null, new HTTP1ServerRequestHandler(this.serverHTTPHandler), this.listener);
            session.attachObject((Object)httpConnection);
            this.serverHTTPHandler.acceptConnection(httpConnection);
        }
    }
}

