/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.net.ByteBufferArrayOutputEntry;
import com.firefly.net.ByteBufferOutputEntry;
import com.firefly.net.EncoderChain;
import com.firefly.net.OutputEntry;
import com.firefly.net.Session;

public class HTTP2ServerEncoder
extends EncoderChain {
    public HTTP2ServerEncoder() {
    }

    public HTTP2ServerEncoder(EncoderChain next) {
        super(next);
    }

    public void encode(Object message, Session session) throws Throwable {
        HTTPConnection connection = (HTTPConnection)session.getAttachment();
        if (connection.isEncrypted()) {
            this.next.encode(message, session);
        } else if (message instanceof ByteBufferArrayOutputEntry) {
            session.write((OutputEntry)((ByteBufferArrayOutputEntry)message));
        } else if (message instanceof ByteBufferOutputEntry) {
            session.write((OutputEntry)((ByteBufferOutputEntry)message));
        } else {
            throw new IllegalArgumentException("the http2 encoder must receive the ByteBufferOutputEntry and ByteBufferArrayOutputEntry, but this message type is " + message.getClass());
        }
    }
}

