/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.stream.AbstractHTTP2Connection;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.net.Decoder;
import com.firefly.net.DecoderChain;
import com.firefly.net.Encoder;
import com.firefly.net.Handler;
import com.firefly.net.Server;
import com.firefly.net.tcp.aio.AsynchronousTcpServer;
import com.firefly.server.http2.HTTP1ServerDecoder;
import com.firefly.server.http2.HTTP1ServerEncoder;
import com.firefly.server.http2.HTTP2ServerDecoder;
import com.firefly.server.http2.HTTP2ServerEncoder;
import com.firefly.server.http2.HTTP2ServerHandler;
import com.firefly.server.http2.HTTP2ServerRequestHandler;
import com.firefly.server.http2.ServerHTTPHandler;
import com.firefly.server.http2.ServerSecureDecoder;
import com.firefly.server.http2.ServerSecureEncoder;
import com.firefly.server.http2.ServerSessionListener;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.time.Millisecond100Clock;

public class HTTP2Server
extends AbstractLifeCycle {
    private final Server server;
    private final HTTP2Configuration http2Configuration;
    private final String host;
    private final int port;

    public HTTP2Server(String host, int port, HTTP2Configuration http2Configuration, ServerHTTPHandler serverHTTPHandler) {
        this(host, port, http2Configuration, new HTTP2ServerRequestHandler(serverHTTPHandler), serverHTTPHandler);
    }

    public HTTP2Server(String host, int port, HTTP2Configuration http2Configuration, ServerSessionListener listener, ServerHTTPHandler serverHTTPHandler) {
        HTTP1ServerEncoder encoder;
        DecoderChain decoder;
        if (http2Configuration == null) {
            throw new IllegalArgumentException("the http2 configuration is null");
        }
        if (host == null) {
            throw new IllegalArgumentException("the http2 server host is empty");
        }
        this.host = host;
        this.port = port;
        if (http2Configuration.isSecureConnectionEnabled()) {
            decoder = new ServerSecureDecoder(new HTTP1ServerDecoder(new HTTP2ServerDecoder()));
            encoder = new HTTP1ServerEncoder(new HTTP2ServerEncoder(new ServerSecureEncoder()));
        } else {
            decoder = new HTTP1ServerDecoder(new HTTP2ServerDecoder());
            encoder = new HTTP1ServerEncoder(new HTTP2ServerEncoder());
        }
        http2Configuration.getTcpConfiguration().setDecoder((Decoder)decoder);
        http2Configuration.getTcpConfiguration().setEncoder((Encoder)encoder);
        http2Configuration.getTcpConfiguration().setHandler((Handler)new HTTP2ServerHandler(http2Configuration, listener, serverHTTPHandler));
        this.server = new AsynchronousTcpServer(http2Configuration.getTcpConfiguration());
        this.http2Configuration = http2Configuration;
    }

    public HTTP2Configuration getHttp2Configuration() {
        return this.http2Configuration;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected void init() {
        this.server.listen(this.host, this.port);
    }

    protected void destroy() {
        if (this.server != null) {
            this.server.stop();
        }
        AbstractHTTP2Connection.stopScheduler();
        LogFactory.getInstance().stop();
        Millisecond100Clock.stop();
    }
}

