/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.decode.HttpParser;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpMethod;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.server.http2.HTTP1ServerConnection;
import com.firefly.server.http2.HTTPServerRequest;
import com.firefly.server.http2.HTTPServerResponse;
import com.firefly.server.http2.ServerHTTPHandler;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP1ServerRequestHandler
implements HttpParser.RequestHandler {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected MetaData.Request request;
    protected MetaData.Response response;
    protected HTTP1ServerConnection connection;
    protected HTTP1ServerConnection.HTTP1ServerResponseOutputStream outputStream;
    protected final ServerHTTPHandler serverHTTPHandler;

    HTTP1ServerRequestHandler(ServerHTTPHandler serverHTTPHandler) {
        this.serverHTTPHandler = serverHTTPHandler;
    }

    @Override
    public boolean startRequest(String method, String uri, HttpVersion version) {
        if (log.isDebugEnabled()) {
            log.debug("server received the request line, {}, {}, {}", new Object[]{method, uri, version});
        }
        this.request = new HTTPServerRequest(method, uri, version);
        this.response = new HTTPServerResponse();
        this.outputStream = new HTTP1ServerConnection.HTTP1ServerResponseOutputStream(this.response, this.connection);
        return HttpMethod.PRI.is(method) && this.connection.upgradeProtocolToHTTP2(this.request, this.response);
    }

    @Override
    public void parsedHeader(HttpField field) {
        this.request.getFields().add(field);
    }

    @Override
    public boolean headerComplete() {
        if (HttpMethod.CONNECT.asString().equalsIgnoreCase(this.request.getMethod())) {
            return this.serverHTTPHandler.acceptHTTPTunnelConnection(this.request, this.response, this.outputStream, this.connection);
        }
        String expectedValue = this.request.getFields().get(HttpHeader.EXPECT);
        if ("100-continue".equalsIgnoreCase(expectedValue)) {
            boolean skipNext = this.serverHTTPHandler.accept100Continue(this.request, this.response, this.outputStream, this.connection);
            if (skipNext) {
                return true;
            }
            this.connection.response100Continue();
            return this.serverHTTPHandler.headerComplete(this.request, this.response, this.outputStream, this.connection);
        }
        boolean success = this.connection.upgradeProtocolToHTTP2(this.request, this.response);
        return success || this.serverHTTPHandler.headerComplete(this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public boolean content(ByteBuffer item) {
        return this.serverHTTPHandler.content(item, this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public boolean contentComplete() {
        return this.serverHTTPHandler.contentComplete(this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public boolean messageComplete() {
        try {
            boolean bl = this.connection.upgradeHTTP2Successfully || this.serverHTTPHandler.messageComplete(this.request, this.response, this.outputStream, this.connection);
            return bl;
        }
        finally {
            this.connection.getParser().reset();
        }
    }

    @Override
    public void badMessage(int status, String reason) {
        this.serverHTTPHandler.badMessage(status, reason, this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public void earlyEOF() {
        this.serverHTTPHandler.earlyEOF(this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public int getHeaderCacheSize() {
        return 1024;
    }
}

