/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.server.http2;

import com.firefly.codec.http2.decode.HttpParser;
import com.firefly.codec.http2.decode.SettingsBodyParser;
import com.firefly.codec.http2.encode.HttpGenerator;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PrefaceFrame;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.codec.http2.model.BadMessageException;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpFields;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpHeaderValue;
import com.firefly.codec.http2.model.HttpMethod;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.AbstractHTTP1Connection;
import com.firefly.codec.http2.stream.AbstractHTTP1OutputStream;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.codec.http2.stream.HTTPTunnelConnection;
import com.firefly.codec.http2.stream.SessionSPI;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.server.http2.HTTP1ServerRequestHandler;
import com.firefly.server.http2.HTTP1ServerTunnelConnection;
import com.firefly.server.http2.HTTP2ServerConnection;
import com.firefly.server.http2.HTTPServerConnection;
import com.firefly.server.http2.ServerSessionListener;
import com.firefly.utils.codec.Base64Utils;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.lang.TypeUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP1ServerConnection
extends AbstractHTTP1Connection
implements HTTPServerConnection {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final ServerSessionListener serverSessionListener;
    private final HTTP1ServerRequestHandler serverRequestHandler;
    boolean upgradeHTTP2Successfully = false;
    Promise<HTTPTunnelConnection> tunnelConnectionPromise;

    HTTP1ServerConnection(HTTP2Configuration config, Session tcpSession, SSLSession sslSession, HTTP1ServerRequestHandler requestHandler, ServerSessionListener serverSessionListener) {
        super(config, sslSession, tcpSession, requestHandler, null);
        requestHandler.connection = this;
        this.serverSessionListener = serverSessionListener;
        this.serverRequestHandler = requestHandler;
    }

    @Override
    protected HttpParser initHttpParser(HTTP2Configuration config, HttpParser.RequestHandler requestHandler, HttpParser.ResponseHandler responseHandler) {
        return new HttpParser(requestHandler, config.getMaxRequestHeadLength());
    }

    @Override
    protected HttpGenerator initHttpGenerator() {
        return new HttpGenerator(true, true);
    }

    HttpParser getParser() {
        return this.parser;
    }

    HttpGenerator getGenerator() {
        return this.generator;
    }

    SSLSession getSSLSession() {
        return this.sslSession;
    }

    Session getTcpSession() {
        return this.tcpSession;
    }

    HTTP2Configuration getHTTP2Configuration() {
        return this.config;
    }

    public MetaData.Request getRequest() {
        return this.serverRequestHandler.request;
    }

    public MetaData.Response getResponse() {
        return this.serverRequestHandler.response;
    }

    void response100Continue() {
        try {
            this.serverRequestHandler.outputStream.response100Continue();
        }
        catch (IOException e) {
            log.error("the server session {} sends 100 continue unsuccessfully", (Throwable)e);
        }
    }

    private void responseH2c() {
        try {
            this.serverRequestHandler.outputStream.responseH2c();
        }
        catch (IOException e) {
            log.error("the server session {} sends 101 switching protocols unsuccessfully", (Throwable)e);
        }
    }

    @Override
    public void upgradeHTTPTunnel(Promise<HTTPTunnelConnection> tunnelConnectionPromise) {
        this.tunnelConnectionPromise = tunnelConnectionPromise;
    }

    HTTP1ServerTunnelConnection createHTTPTunnel() {
        if (this.tunnelConnectionPromise != null) {
            HTTP1ServerTunnelConnection tunnelConnection = new HTTP1ServerTunnelConnection(this.sslSession, this.tcpSession, this.httpVersion);
            this.tunnelConnectionPromise.succeeded((Object)tunnelConnection);
            this.tcpSession.attachObject((Object)tunnelConnection);
            return tunnelConnection;
        }
        return null;
    }

    boolean upgradeProtocolToHTTP2(MetaData.Request request, MetaData.Response response) {
        if (HttpMethod.PRI.is(request.getMethod())) {
            HTTP2ServerConnection http2ServerConnection = new HTTP2ServerConnection(this.config, this.tcpSession, this.sslSession, this.serverSessionListener);
            this.tcpSession.attachObject((Object)http2ServerConnection);
            http2ServerConnection.getParser().directUpgrade();
            this.upgradeHTTP2Successfully = true;
            return true;
        }
        HttpField connectionField = request.getFields().getField(HttpHeader.CONNECTION);
        if (connectionField != null) {
            if (connectionField.contains("Upgrade")) {
                if (log.isDebugEnabled()) {
                    log.debug("the server will upgrade protocol {}", (Object)request.getFields());
                }
                if (request.getFields().contains(HttpHeader.UPGRADE, "h2c")) {
                    HttpField settingsField = request.getFields().getField(HttpHeader.HTTP2_SETTINGS);
                    if (settingsField != null) {
                        SettingsFrame settingsFrame;
                        response.setStatus(101);
                        response.getFields().put(HttpHeader.CONNECTION, HttpHeaderValue.UPGRADE);
                        response.getFields().put(HttpHeader.UPGRADE, "h2c");
                        byte[] settings = Base64Utils.decodeFromUrlSafeString((String)settingsField.getValue());
                        if (log.isDebugEnabled()) {
                            log.debug("the server received settings {}", (Object)TypeUtils.toHexString((byte[])settings));
                        }
                        if ((settingsFrame = SettingsBodyParser.parseBody(BufferUtils.toBuffer((byte[])settings))) == null) {
                            throw new BadMessageException("settings frame parsing error");
                        }
                        this.responseH2c();
                        HTTP2ServerConnection http2ServerConnection = new HTTP2ServerConnection(this.config, this.tcpSession, this.sslSession, this.serverSessionListener);
                        this.tcpSession.attachObject((Object)http2ServerConnection);
                        http2ServerConnection.getParser().standardUpgrade();
                        this.serverSessionListener.onAccept(http2ServerConnection.getHttp2Session());
                        SessionSPI sessionSPI = http2ServerConnection.getSessionSPI();
                        sessionSPI.onFrame(new PrefaceFrame());
                        sessionSPI.onFrame(settingsFrame);
                        sessionSPI.onFrame(new HeadersFrame(1, request, null, true));
                        this.upgradeHTTP2Successfully = true;
                        return true;
                    }
                    throw new IllegalStateException("upgrade HTTP2 unsuccessfully");
                }
                return false;
            }
            return false;
        }
        return false;
    }

    static class HTTP1ServerResponseOutputStream
    extends AbstractHTTP1OutputStream {
        private static final MetaData.Response H2C_RESPONSE = new MetaData.Response(HttpVersion.HTTP_1_1, 101, new HttpFields());
        private final HTTP1ServerConnection connection;

        HTTP1ServerResponseOutputStream(MetaData.Response response, HTTP1ServerConnection connection) {
            super(response, false);
            this.connection = connection;
        }

        HTTP1ServerConnection getHTTP1ServerConnection() {
            return this.connection;
        }

        void responseH2c() throws IOException {
            ByteBuffer header = this.getHeaderByteBuffer();
            HttpGenerator gen = this.getHttpGenerator();
            HttpGenerator.Result result = gen.generateResponse(H2C_RESPONSE, false, header, null, null, true);
            if (result == HttpGenerator.Result.FLUSH && gen.getState() == HttpGenerator.State.COMPLETING) {
                this.getSession().encode((Object)header);
                result = gen.generateResponse(null, false, null, null, null, true);
                if (result == HttpGenerator.Result.DONE && gen.getState() == HttpGenerator.State.END) {
                    log.debug("the server session {} sends 101 switching protocols successfully", (Object)this.getSession().getSessionId());
                } else {
                    this.generateHTTPMessageExceptionally(result, gen.getState());
                }
            } else {
                this.generateHTTPMessageExceptionally(result, gen.getState());
            }
        }

        void response100Continue() throws IOException {
            ByteBuffer header = this.getHeaderByteBuffer();
            HttpGenerator gen = this.getHttpGenerator();
            HttpGenerator.Result result = gen.generateResponse(HttpGenerator.CONTINUE_100_INFO, false, header, null, null, false);
            if (result == HttpGenerator.Result.FLUSH && gen.getState() == HttpGenerator.State.COMPLETING_1XX) {
                this.getSession().encode((Object)header);
                result = gen.generateResponse(null, false, null, null, null, false);
                if (result == HttpGenerator.Result.DONE && gen.getState() == HttpGenerator.State.START) {
                    log.debug("the server session {} sends 100 continue successfully", (Object)this.getSession().getSessionId());
                } else {
                    this.generateHTTPMessageExceptionally(result, gen.getState());
                }
            } else {
                this.generateHTTPMessageExceptionally(result, gen.getState());
            }
        }

        @Override
        protected void generateHTTPMessageSuccessfully() {
            log.debug("server session {} generates the HTTP message completely", (Object)this.connection.getSessionId());
            MetaData.Response response = this.connection.getResponse();
            MetaData.Request request = this.connection.getRequest();
            String requestConnectionValue = request.getFields().get(HttpHeader.CONNECTION);
            String responseConnectionValue = response.getFields().get(HttpHeader.CONNECTION);
            this.connection.getGenerator().reset();
            switch (request.getHttpVersion()) {
                case HTTP_1_0: {
                    if ("keep-alive".equalsIgnoreCase(requestConnectionValue) && "keep-alive".equalsIgnoreCase(responseConnectionValue)) {
                        log.debug("the server {} connection {} is persistent", (Object)response.getHttpVersion(), (Object)this.connection.getSessionId());
                        break;
                    }
                    try {
                        this.connection.close();
                    }
                    catch (IOException e) {
                        log.error("server closes connection exception", (Throwable)e);
                    }
                    break;
                }
                case HTTP_1_1: {
                    if ("close".equalsIgnoreCase(requestConnectionValue) || "close".equalsIgnoreCase(responseConnectionValue)) {
                        try {
                            this.connection.close();
                        }
                        catch (IOException e) {
                            log.error("server closes connection exception", (Throwable)e);
                        }
                        break;
                    }
                    log.debug("the server {} connection {} is persistent", (Object)response.getHttpVersion(), (Object)this.connection.getSessionId());
                    break;
                }
                default: {
                    throw new IllegalStateException("server response does not support the http version " + (Object)((Object)this.connection.getHttpVersion()));
                }
            }
        }

        @Override
        protected void generateHTTPMessageExceptionally(HttpGenerator.Result generatorResult, HttpGenerator.State generatorState) {
            if (log.isDebugEnabled()) {
                log.debug("http1 generator error, the result is {}, and the generator state is {}", (Object)generatorResult, (Object)generatorState);
            }
            this.connection.getGenerator().reset();
            throw new IllegalStateException("server generates http message exception.");
        }

        @Override
        protected ByteBuffer getHeaderByteBuffer() {
            return BufferUtils.allocate((int)this.connection.getHTTP2Configuration().getMaxRequestHeadLength());
        }

        @Override
        protected Session getSession() {
            return this.connection.getTcpSession();
        }

        @Override
        protected HttpGenerator getHttpGenerator() {
            return this.connection.getGenerator();
        }

        static {
            H2C_RESPONSE.getFields().put(HttpHeader.CONNECTION, HttpHeaderValue.UPGRADE);
            H2C_RESPONSE.getFields().put(HttpHeader.UPGRADE, "h2c");
        }
    }
}

