/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.view;

import com.firefly.mvc.web.View;
import com.firefly.mvc.web.servlet.SystemHtmlPage;
import com.firefly.template.Config;
import com.firefly.template.Model;
import com.firefly.template.TemplateFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateView
implements View {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected static TemplateFactory templateFactory;
    protected static boolean init;
    protected static String charset;
    protected static String _viewPath;
    protected String page;

    public static void init(String viewPath, String encoding) {
        if (!init) {
            log.info("the template path is {}", (Object)viewPath);
            _viewPath = viewPath;
            Config config = new Config();
            config.setViewPath(viewPath);
            config.setCharset(encoding);
            charset = encoding;
            templateFactory = new TemplateFactory(config).init();
            init = true;
        }
    }

    public static TemplateFactory getTemplateFactory() {
        return templateFactory;
    }

    public static String getCharset() {
        return charset;
    }

    public static String getViewPath() {
        return _viewPath;
    }

    public String getPage() {
        return this.page;
    }

    public TemplateView(String page) {
        this.page = page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(final HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        com.firefly.template.View v = templateFactory.getView(this.page);
        if (v == null) {
            SystemHtmlPage.responseSystemPage(request, response, templateFactory.getConfig().getCharset(), 404, "template: " + this.page + "not found");
            return;
        }
        response.setCharacterEncoding(templateFactory.getConfig().getCharset());
        response.setHeader("Content-Type", "text/html; charset=" + templateFactory.getConfig().getCharset());
        Model model = new Model(){

            public void clear() {
                Enumeration e = request.getAttributeNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    request.removeAttribute(name);
                }
            }

            public Object get(String name) {
                return request.getAttribute(name);
            }

            public void put(String name, Object o) {
                request.setAttribute(name, o);
            }

            public void remove(String name) {
                request.removeAttribute(name);
            }
        };
        try (ServletOutputStream out = response.getOutputStream();){
            v.render(model, (OutputStream)out);
        }
    }

    static {
        init = false;
        charset = "UTF-8";
    }
}

