/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.view;

import com.firefly.mvc.web.Constants;
import com.firefly.mvc.web.FileAccessFilter;
import com.firefly.mvc.web.View;
import com.firefly.mvc.web.servlet.SystemHtmlPage;
import com.firefly.server.exception.HttpServerException;
import com.firefly.utils.RandomUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.CountingCallback;
import com.firefly.utils.io.BufferReaderHandler;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileView
implements View {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    public static final String CRLF = "\r\n";
    private static Set<String> ALLOW_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "HEAD"));
    private static String RANGE_ERROR_HTML = SystemHtmlPage.systemPageTemplate(416, "None of the range-specifier values in the Range request-header field overlap the current extent of the selected resource.");
    private static int MAX_RANGE_NUM;
    private static String SERVER_HOME;
    private static Path SERVER_HOME_PATH;
    private static String CHARACTER_ENCODING;
    private static String TEMPLATE_PATH;
    private static FileAccessFilter FILE_ACCESS_FILTER;
    private final String inputPath;

    public StaticFileView(String path) {
        this.inputPath = path;
    }

    public static void init(String characterEncoding, FileAccessFilter fileAccessFilter, String serverHome, int maxRangeNum, String tempPath) {
        if (VerifyUtils.isNotEmpty((String)characterEncoding)) {
            CHARACTER_ENCODING = characterEncoding;
        }
        if (fileAccessFilter != null) {
            FILE_ACCESS_FILTER = fileAccessFilter;
        }
        SERVER_HOME = serverHome;
        SERVER_HOME_PATH = Paths.get(serverHome, new String[0]).normalize();
        MAX_RANGE_NUM = maxRangeNum;
        if (TEMPLATE_PATH == null && tempPath != null) {
            TEMPLATE_PATH = tempPath;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void render(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        Object object;
        ArrayList<MultipartByteranges> tmpByteRangeSets;
        String boundary;
        long fileLen;
        String range;
        FileServletOutputStream out;
        if (this.inputPath.startsWith(TEMPLATE_PATH)) {
            SystemHtmlPage.responseSystemPage(request, response, CHARACTER_ENCODING, 404, request.getRequestURI() + " not found");
            return;
        }
        if (!ALLOW_METHODS.contains(request.getMethod())) {
            response.setHeader("Allow", "GET,POST,HEAD");
            SystemHtmlPage.responseSystemPage(request, response, CHARACTER_ENCODING, 405, "Only support GET, POST or HEAD method");
            return;
        }
        String path = FILE_ACCESS_FILTER.doFilter(request, response, this.inputPath);
        if (VerifyUtils.isEmpty((String)path)) {
            return;
        }
        Path currentPath = Paths.get(SERVER_HOME, path).normalize();
        if (!currentPath.startsWith(SERVER_HOME_PATH)) {
            if (log.isDebugEnabled()) {
                log.debug("the current path [{}] is not start with server home [{}]", (Object)currentPath, (Object)SERVER_HOME_PATH);
            }
            SystemHtmlPage.responseSystemPage(request, response, CHARACTER_ENCODING, 404, request.getRequestURI() + " not found");
            return;
        }
        File file = currentPath.toFile();
        if (!file.exists() || file.isDirectory()) {
            SystemHtmlPage.responseSystemPage(request, response, CHARACTER_ENCODING, 404, request.getRequestURI() + " not found");
            return;
        }
        String fileSuffix = StaticFileView.getFileSuffix(file.getName()).toLowerCase();
        String contentType = Constants.MIME.get(fileSuffix);
        if (contentType == null) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
        } else {
            String[] type = StringUtils.split((String)contentType, (char)'/');
            if ("application".equals(type[0])) {
                response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            } else if ("text".equals(type[0])) {
                contentType = contentType + "; charset=" + CHARACTER_ENCODING;
            }
            response.setContentType(contentType);
        }
        try {
            out = new FileServletOutputStream(request, response, response.getOutputStream());
            Throwable throwable = null;
            try {
                range = request.getHeader("Range");
                if (range == null) {
                    out.write(file);
                    return;
                }
                String[] rangesSpecifier = StringUtils.split((String)range, (char)'=');
                if (rangesSpecifier.length != 2) {
                    response.setStatus(416);
                    out.write(RANGE_ERROR_HTML.getBytes(CHARACTER_ENCODING));
                    return;
                }
                fileLen = file.length();
                String byteRangeSet = rangesSpecifier[1].trim();
                String[] byteRangeSets = StringUtils.split((String)byteRangeSet, (char)',');
                if (byteRangeSets.length > 1) {
                    boundary = "ff10" + RandomUtils.randomString((int)13);
                    if (byteRangeSets.length > MAX_RANGE_NUM) {
                        log.error("multipart range more than {}", (Object)MAX_RANGE_NUM);
                        response.setStatus(416);
                        out.write(RANGE_ERROR_HTML.getBytes(CHARACTER_ENCODING));
                        return;
                    }
                } else {
                    String tmp = byteRangeSets[0].trim();
                    String[] byteRange = StringUtils.split((String)tmp, (char)'-');
                    if (byteRange.length == 1) {
                        long pos = Long.parseLong(byteRange[0].trim());
                        if (pos == 0L) {
                            response.setStatus(416);
                            out.write(RANGE_ERROR_HTML.getBytes(CHARACTER_ENCODING));
                            return;
                        }
                        if (tmp.charAt(0) == '-') {
                            long lastBytePos = fileLen - 1L;
                            long firstBytePos = lastBytePos - pos + 1L;
                            this.writePartialFile(request, response, out, file, firstBytePos, lastBytePos, fileLen);
                        } else {
                            if (tmp.charAt(tmp.length() - 1) != '-') {
                                response.setStatus(416);
                                out.write(RANGE_ERROR_HTML.getBytes(CHARACTER_ENCODING));
                                return;
                            }
                            this.writePartialFile(request, response, out, file, pos, fileLen - 1L, fileLen);
                        }
                    } else {
                        long firstBytePos = Long.parseLong(byteRange[0].trim());
                        long lastBytePos = Long.parseLong(byteRange[1].trim());
                        if (firstBytePos > fileLen || firstBytePos >= lastBytePos) {
                            response.setStatus(416);
                            out.write(RANGE_ERROR_HTML.getBytes(CHARACTER_ENCODING));
                            return;
                        }
                        if (lastBytePos >= fileLen) {
                            lastBytePos = fileLen - 1L;
                        }
                        this.writePartialFile(request, response, out, file, firstBytePos, lastBytePos, fileLen);
                    }
                    log.debug("single range download|{}", (Object)range);
                    return;
                }
                tmpByteRangeSets = new ArrayList<MultipartByteranges>(MAX_RANGE_NUM);
                object = byteRangeSets;
                n = ((String[])object).length;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error("static file output exception", e);
            throw new HttpServerException("get static file output stream error");
        }
        for (int i = 0; i < n; ++i) {
            long lastBytePos;
            String t = object[i];
            String tmp = t.trim();
            String[] byteRange = StringUtils.split((String)tmp, (char)'-');
            if (byteRange.length == 1) {
                long lastBytePos2;
                long firstBytePos;
                MultipartByteranges multipartByteranges;
                long pos = Long.parseLong(byteRange[0].trim());
                if (pos == 0L) continue;
                if (tmp.charAt(0) == '-') {
                    lastBytePos = fileLen - 1L;
                    long firstBytePos2 = lastBytePos - pos + 1L;
                    if (firstBytePos2 > lastBytePos) continue;
                    multipartByteranges = this.getMultipartByteranges(contentType, firstBytePos2, lastBytePos, fileLen, boundary);
                    tmpByteRangeSets.add(multipartByteranges);
                    continue;
                }
                if (tmp.charAt(tmp.length() - 1) != '-' || (firstBytePos = pos) > (lastBytePos2 = fileLen - 1L)) continue;
                multipartByteranges = this.getMultipartByteranges(contentType, firstBytePos, lastBytePos2, fileLen, boundary);
                tmpByteRangeSets.add(multipartByteranges);
                continue;
            }
            long firstBytePos = Long.parseLong(byteRange[0].trim());
            lastBytePos = Long.parseLong(byteRange[1].trim());
            if (firstBytePos > fileLen || firstBytePos >= lastBytePos) continue;
            MultipartByteranges multipartByteranges = this.getMultipartByteranges(contentType, firstBytePos, lastBytePos, fileLen, boundary);
            tmpByteRangeSets.add(multipartByteranges);
        }
        if (tmpByteRangeSets.size() <= 0) {
            response.setStatus(416);
            out.write(RANGE_ERROR_HTML.getBytes(CHARACTER_ENCODING));
            return;
        }
        response.setStatus(206);
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Content-Type", "multipart/byteranges; boundary=" + boundary);
        object = tmpByteRangeSets.iterator();
        while (true) {
            if (!object.hasNext()) {
                out.write(("\r\n--" + boundary + "--" + CRLF).getBytes(CHARACTER_ENCODING));
                log.debug("multipart download|{}", (Object)range);
                return;
            }
            MultipartByteranges m = (MultipartByteranges)object.next();
            long length = m.lastBytePos - m.firstBytePos + 1L;
            out.write(m.head.getBytes(CHARACTER_ENCODING));
            out.write(file, m.firstBytePos, length);
        }
    }

    private void writePartialFile(HttpServletRequest request, HttpServletResponse response, FileServletOutputStream out, File file, long firstBytePos, long lastBytePos, long fileLen) throws Throwable {
        long length = lastBytePos - firstBytePos + 1L;
        if (length <= 0L) {
            response.setStatus(416);
            out.write(RANGE_ERROR_HTML.getBytes(CHARACTER_ENCODING));
            return;
        }
        response.setStatus(206);
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Content-Range", "bytes " + firstBytePos + "-" + lastBytePos + "/" + fileLen);
        out.write(file, firstBytePos, length);
    }

    public static String getFileSuffix(String name) {
        if (name.charAt(name.length() - 1) == '.') {
            return "*";
        }
        for (int i = name.length() - 2; i >= 0; --i) {
            if (name.charAt(i) != '.') continue;
            return name.substring(i + 1, name.length());
        }
        return "*";
    }

    private MultipartByteranges getMultipartByteranges(String contentType, long firstBytePos, long lastBytePos, long fileLen, String boundary) {
        MultipartByteranges ret = new MultipartByteranges();
        ret.firstBytePos = firstBytePos;
        ret.lastBytePos = lastBytePos;
        ret.head = "\r\n--" + boundary + CRLF + "Content-Type: " + contentType + CRLF + "Content-range: bytes " + firstBytePos + "-" + lastBytePos + "/" + fileLen + CRLF + CRLF;
        return ret;
    }

    static {
        CHARACTER_ENCODING = "UTF-8";
        FILE_ACCESS_FILTER = new FileAccessFilter(){

            @Override
            public String doFilter(HttpServletRequest request, HttpServletResponse response, String path) {
                return path;
            }
        };
    }

    private class FileServletOutputStream
    extends ServletOutputStream {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final ServletOutputStream out;
        private final Queue<ChunkedData> queue = new LinkedList<ChunkedData>();
        private long size;

        public FileServletOutputStream(HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) {
            this.request = request;
            this.response = response;
            this.out = out;
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.queue.offer(new ByteChunkedData((byte)b));
            ++this.size;
        }

        public void write(byte[] array, int offset, int length) throws IOException {
            ByteArrayChunkedData c = new ByteArrayChunkedData(array, offset, length);
            this.queue.offer(c);
            this.size += (long)length;
        }

        public void write(File file) throws IOException {
            long len = file.length();
            SequenceAccessFileChunkedData data = new SequenceAccessFileChunkedData(file, len);
            this.queue.offer(data);
            this.size += data.getLength();
        }

        public void write(File file, long off, long len) throws IOException {
            this.queue.offer(new RandomAccessFileChunkedData(file, off, len));
            this.size += len;
        }

        public void print(String string) throws IOException {
            this.write(string.getBytes(this.response.getCharacterEncoding()));
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            if (!this.response.isCommitted()) {
                this.response.setHeader("Content-Length", String.valueOf(this.size));
            }
            if (this.size > 0L) {
                if (this.request.getMethod().equals("HEAD")) {
                    this.queue.clear();
                } else {
                    ChunkedData d = null;
                    while ((d = this.queue.poll()) != null) {
                        d.write();
                    }
                }
                this.size = 0L;
            }
            this.out.close();
        }

        private abstract class ChunkedData {
            private ChunkedData() {
            }

            public abstract void write() throws IOException;
        }

        private class ByteArrayChunkedData
        extends ChunkedData {
            private final byte[] b;
            private final int len;
            private final int off;

            public ByteArrayChunkedData(byte[] b, int off, int len) {
                this.b = b;
                this.off = off;
                this.len = len;
            }

            @Override
            public void write() throws IOException {
                FileServletOutputStream.this.out.write(this.b, this.off, this.len);
            }
        }

        private class ByteChunkedData
        extends ChunkedData {
            private final byte b;

            public ByteChunkedData(byte b) {
                this.b = b;
            }

            @Override
            public void write() throws IOException {
                FileServletOutputStream.this.out.write((int)this.b);
            }
        }

        private class RandomAccessFileChunkedData
        extends ChunkedData {
            private final long len;
            private final long off;
            private final File file;

            public RandomAccessFileChunkedData(File file, long off, long len) {
                this.off = off;
                this.len = len;
                this.file = file;
            }

            @Override
            public void write() throws IOException {
                try (FileChannel fc = FileChannel.open(Paths.get(this.file.toURI()), StandardOpenOption.READ);){
                    FileUtils.transferTo((FileChannel)fc, (long)this.off, (long)this.len, (Callback)Callback.NOOP, (BufferReaderHandler)new FileBufferReaderHandler(this.len));
                }
            }
        }

        private class SequenceAccessFileChunkedData
        extends ChunkedData {
            private final File file;
            private final long len;

            public SequenceAccessFileChunkedData(File file, long len) {
                this.file = file;
                this.len = len;
            }

            public long getLength() {
                return this.len;
            }

            @Override
            public void write() throws IOException {
                try (FileChannel fc = FileChannel.open(Paths.get(this.file.toURI()), StandardOpenOption.READ);){
                    FileUtils.transferTo((FileChannel)fc, (long)this.len, (Callback)Callback.NOOP, (BufferReaderHandler)new FileBufferReaderHandler(this.len));
                }
            }
        }

        private class FileBufferReaderHandler
        implements BufferReaderHandler {
            private final long len;

            public FileBufferReaderHandler(long len) {
                this.len = len;
            }

            public void readBuffer(ByteBuffer buf, CountingCallback countingCallback, long count) throws IOException {
                log.debug("write file,  count: {} , lenth: {}", (Object)count, (Object)this.len);
                FileServletOutputStream.this.out.write(BufferUtils.toArray((ByteBuffer)buf));
            }
        }
    }

    private class MultipartByteranges {
        public String head;
        public long firstBytePos;
        public long lastBytePos;

        private MultipartByteranges() {
        }
    }
}

