/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.support;

import com.firefly.annotation.Component;
import com.firefly.annotation.Controller;
import com.firefly.annotation.Interceptor;
import com.firefly.annotation.RequestMapping;
import com.firefly.core.support.BeanDefinition;
import com.firefly.core.support.annotation.AnnotationBeanDefinition;
import com.firefly.core.support.annotation.AnnotationBeanReader;
import com.firefly.mvc.web.support.ControllerAnnotatedBeanDefinition;
import com.firefly.mvc.web.support.InterceptorAnnotatedBeanDefinition;
import com.firefly.utils.ReflectUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebBeanReader
extends AnnotationBeanReader {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public WebBeanReader() {
        this(null);
    }

    public WebBeanReader(String file) {
        super(file);
    }

    @Override
    protected BeanDefinition getBeanDefinition(Class<?> c) {
        if (c.isAnnotationPresent(Controller.class) || c.isAnnotationPresent(Component.class)) {
            log.info("classes [{}]", (Object)c.getName());
            return this.componentParser(c);
        }
        if (c.isAnnotationPresent(Interceptor.class)) {
            log.info("classes [{}]", (Object)c.getName());
            return this.interceptorParser(c);
        }
        return null;
    }

    @Override
    protected BeanDefinition componentParser(Class<?> c) {
        ControllerAnnotatedBeanDefinition beanDefinition = new ControllerAnnotatedBeanDefinition();
        this.setWebBeanDefinition(beanDefinition, c);
        List<Method> reqMethods = this.getReqMethods(c);
        beanDefinition.setReqMethods(reqMethods);
        return beanDefinition;
    }

    private BeanDefinition interceptorParser(Class<?> c) {
        InterceptorAnnotatedBeanDefinition beanDefinition = new InterceptorAnnotatedBeanDefinition();
        this.setWebBeanDefinition(beanDefinition, c);
        beanDefinition.setDisposeMethod(this.getInterceptors(c));
        String uriPattern = c.getAnnotation(Interceptor.class).uri();
        beanDefinition.setUriPattern(uriPattern);
        Integer order = c.getAnnotation(Interceptor.class).order();
        beanDefinition.setOrder(order);
        return beanDefinition;
    }

    private void setWebBeanDefinition(AnnotationBeanDefinition beanDefinition, Class<?> c) {
        beanDefinition.setClassName(c.getName());
        beanDefinition.setId(this.getId(c));
        beanDefinition.setInterfaceNames(ReflectUtils.getInterfaceNames(c));
        beanDefinition.setInjectFields(this.getInjectField(c));
        beanDefinition.setInjectMethods(this.getInjectMethod(c));
        beanDefinition.setConstructor(this.getInjectConstructor(c));
        beanDefinition.setInitMethod(this.getInitMethod(c));
        beanDefinition.setDestroyedMethod(this.getDestroyedMethod(c));
    }

    private String getId(Class<?> c) {
        if (c.isAnnotationPresent(Controller.class)) {
            return c.getAnnotation(Controller.class).value();
        }
        if (c.isAnnotationPresent(Interceptor.class)) {
            return c.getAnnotation(Interceptor.class).value();
        }
        if (c.isAnnotationPresent(Component.class)) {
            return c.getAnnotation(Component.class).value();
        }
        return "";
    }

    private List<Method> getReqMethods(Class<?> c) {
        Method[] methods = c.getMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : methods) {
            if (!m.isAnnotationPresent(RequestMapping.class)) continue;
            list.add(m);
        }
        return list;
    }

    private Method getInterceptors(Class<?> c) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals("dispose")) continue;
            return m;
        }
        return null;
    }
}

